<?php


class HD
{

	public static function ver()
    {
		$ver = file_get_contents(DuneSystem::$properties['install_dir_path'].'/dune_plugin.xml');
			if (is_null($ver)) {
					hd_print('Can`t load dune_plugin.xml');
					return 'n/a';
				}
		$xml = HD::parse_xml_document($ver);
		$plugin_version = strval($xml->version);
		return $plugin_version;
	}


    public static function is_map($a){
        return is_array($a) &&
            array_diff_key($a, array_keys(array_keys($a)));
    }

    

    public static function has_attribute($obj, $n){
        $arr = (array) $obj;
        return isset($arr[$n]);
    }
    

    public static function get_map_element($map, $key){
        return isset($map[$key]) ? $map[$key] : null;
    }

    

    public static function starts_with($str, $pattern){
        return strpos($str, $pattern) === 0;
    }

    

    public static function format_timestamp($ts, $fmt = null){
        // NOTE: for some reason, explicit timezone is required for PHP
        // on Dune (no builtin timezone info?).

        if (is_null($fmt))
            $fmt = 'Y:m:d H:i:s';

        $dt = new DateTime('@' . $ts);
        return $dt->format($fmt);
    }

    

    public static function format_duration($msecs){
        $n = intval($msecs);

        if (strlen($msecs) <= 0 || $n <= 0)
            return "--:--";

        $n = $n / 1000;
        $hours = $n / 3600;
        $remainder = $n % 3600;
        $minutes = $remainder / 60;
        $seconds = $remainder % 60;

        if (intval($hours) > 0)
        {
            return sprintf("%d:%02d:%02d", $hours, $minutes, $seconds);
        }
        else
        {
            return sprintf("%02d:%02d", $minutes, $seconds);
        }
    }

    public static function sec_format_duration($secs){
        $n = intval($secs);

        if (strlen($secs) <= 0 || $n <= 0)
            return "--:--";

        $hours = $n / 3600;
        $remainder = $n % 3600;
        $minutes = $remainder / 60;
        $seconds = $remainder % 60;

        if (intval($hours) > 0)
        {
            return sprintf("%d:%02d:%02d", $hours, $minutes, $seconds);
        }
        else
        {
            return sprintf("%02d:%02d", $minutes, $seconds);
        }
    }

    public static function encode_user_data($a, $b = null){
        $media_url = null;
        $user_data = null;

        if (is_array($a) && is_null($b))
        {
            $media_url = '';
            $user_data = $a;
        }
        else
        {
            $media_url = $a;
            $user_data = $b;
        }

        if (!is_null($user_data))
            $media_url .= '||' . json_encode($user_data);

        return $media_url;
    }

    

    public static function decode_user_data($media_url_str, &$media_url, &$user_data){
        $idx = strpos($media_url_str, '||');

        if ($idx === false)
        {
            $media_url = $media_url_str;
            $user_data = null;
            return;
        }

        $media_url = substr($media_url_str, 0, $idx);
        $user_data = json_decode(substr($media_url_str, $idx + 2));
    }

    

    public static function create_regular_folder_range($items,
        $from_ndx = 0, $total = -1, $more_items_available = false){
        if ($total === -1)
            $total = $from_ndx + count($items);

        if ($from_ndx >= $total)
        {
            $from_ndx = $total;
            $items = array();
        }
        else if ($from_ndx + count($items) > $total)
        {
            array_splice($items, $total - $from_ndx);
        }

        return array
        (
            PluginRegularFolderRange::total => intval($total),
            PluginRegularFolderRange::more_items_available => $more_items_available,
            PluginRegularFolderRange::from_ndx => intval($from_ndx),
            PluginRegularFolderRange::count => count($items),
            PluginRegularFolderRange::items => $items
        );
    }

    

    public static function http_get_document($url, $opts = null){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 	0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 	0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT,    40);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION,    1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,    true);
        curl_setopt($ch, CURLOPT_TIMEOUT,           40);
        curl_setopt($ch, CURLOPT_USERAGENT,         "Mozilla/5.0 (Windows NT 5.1; rv:7.0.1) Gecko/20100101 Firefox/7.0.1");
		curl_setopt($ch, CURLOPT_ENCODING,          1);
        curl_setopt($ch, CURLOPT_URL,               $url);
        if (isset($opts))
        {
            foreach ($opts as $k => $v)
                curl_setopt($ch, $k, $v);
        }
        echo("HTTP fetching '$url'...");
        $content = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if($content === false)
        {
            $err_msg = "HTTP error: $http_code (" . curl_error($ch) . ')';
            echo($err_msg);
        }
        if ($http_code != 200)
        {
            $err_msg = "HTTP request failed ($http_code)";
            echo($err_msg);
        }
        echo("HTTP OK ($http_code)");
        curl_close($ch);
        return $content;
    }

    

    public static function http_post_document($url, $post_data){
        return self::http_get_document($url,
            array
            (
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $post_data
            ));
    }

    

    public static function parse_xml_document($doc){
        $xml = simplexml_load_string($doc);

        if ($xml === false)
        {
            echo("Error: can not parse XML document.");
            echo("XML-text: $doc.");
            echo('Illegal XML document');
        }

        return $xml;
    }

    

    public static function make_json_rpc_request($op_name, $params){
        static $request_id = 0;

        $request = array
        (
            'jsonrpc' => '2.0',
            'id' => ++$request_id,
            'method' => $op_name,
            'params' => $params
        );

        return $request;
    }
    
    public static function get_ip_address(){
        static $ip_address = null;
        if (is_null($ip_address)){
            preg_match_all('/Link encap:Ethernet.*?inet'.(false ? '6?' : '').' addr: ?([^ ]+)/ms', `ifconfig`, $ips);
			if ($ips[1][0]!= '127.0.0.1')
				$ip_address = $ips[1][0];
			else if ($ips[1][1]!= '127.0.0.1')
				$ip_address = $ips[1][1];
        }
        return $ip_address;
    }
    
    public static function get_mac_addr($arg=null){
        static $mac_addr = null;
        if (is_null($mac_addr)){
            $mac_addr = shell_exec(
                'ifconfig  eth0 | head -1 | sed "s/^.*HWaddr //"');
            $mac_addr = trim($mac_addr);
        }
		if ($arg==true)
			$mac_addr = str_replace(":", "", $mac_addr);
        return $mac_addr;
    }

    

    // TODO: localization
    private static $MONTHS = array(
        'January',
        'February',
        'March',
        'April',
        'May',
        'June',
        'July',
        'August',
        'September',
        'October',
        'November',
        'December',
    );

    public static function format_date_time_date($tm){
        $lt = localtime($tm);
        $mon = self::$MONTHS[$lt[4]];
        return sprintf("%02d %s %04d", $lt[3], $mon, $lt[5] + 1900);
    }

    public static function format_date_time_time($tm, $with_sec = false){
        $format = '%H:%M';
        if ($with_sec)
            $format .= ':%S';
        return strftime($format, $tm);
    }

    public static function print_backtrace(){
        echo('Back trace:');
        foreach (debug_backtrace() as $f)
        {
            echo(
                '  - ' . $f['function'] . 
                ' at ' . $f['file'] . ':' . $f['line']);
        }
    }
    public static function get_filesize_str($size){
		if( $size < 1024 )
		{
			$size_num = $size;
			$size_suf = "B";
		}
		else if( $size < 1048576 ) // 1M
		{
			$size_num = round($size / 1024, 2);
			$size_suf = "KB";
		}
		else if( $size < 1073741824 ) // 1G
		{
			$size_num = round($size / 1048576, 2);
			$size_suf = "MB";
		}
		else
		{
			$size_num = round($size / 1073741824, 2);
			$size_suf = "GB";
		}
		return "$size_num $size_suf";
    }
	
	public static function get_storage_size($path, $arg=null){
		$d[0] = disk_free_space($path);
		$d[1] = disk_total_space($path);
		foreach ($d as $bytes){
			$si_prefix = array( 'B', 'KB', 'MB', 'GB', 'TB', 'EB', 'ZB', 'YB' );
			$base = 1024;
			$class = min((int)log($bytes , $base) , count($si_prefix) - 1);
			$size[] = sprintf('%1.2f' , $bytes / pow($base,$class)) . ' ' . $si_prefix[$class];
		}
		if ($arg==true){
			$arr['str'] = $size[0] . '/' . $size[1];
			if ($arg < $d[0])
				$arr['free_space'] = true;
			else
				$arr['free_space'] = false;
			return $arr;
		}
		return $size[0] . '/' . $size[1];
    }
	
	public static function get_items($path, $macAdr=null) {
		$items = array();
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		if ($path=='data_dir_path')
			$link = DuneSystem::$properties['data_dir_path'] . '/'. $path;
		else
			$link = SmartConfig::get_data_path() . '/'. $path;
		if (file_exists($link))
			$items = unserialize(file_get_contents($link));
		return $items;
	}
	
	public static function save_items($path, $items, $macAdr=null){
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		if ($path=='data_dir_path')
			$link = DuneSystem::$properties['data_dir_path'] . '/'. $path;
		else
			$link = SmartConfig::get_data_path() . '/'. $path;
		file_put_contents ($link, serialize($items));
	}
	
	public static function save_items_tmp($path, $items, $macAdr=null) {
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		$link = DuneSystem::$properties['tmp_dir_path']. '/' .$path;
		file_put_contents ($link, serialize($items));
	}
	
	public static function get_items_tmp($path, $macAdr=null) {
		$item = '';
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		$data_path = DuneSystem::$properties['tmp_dir_path']. '/' .$path;
			if (file_exists($data_path))
				$item = unserialize(file_get_contents($data_path));
		return $item;
	}
	
	public static function save_item($path, $item, $macAdr=null) {
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		$link = SmartConfig::get_data_path() . '/'. $path;
		file_put_contents ($link, $item);
	}
	public static function get_item($path, $macAdr=null) {
		$item = '';
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		$link = SmartConfig::get_data_path() . '/'. $path;
				if (file_exists($link))
					$item = file_get_contents($link);
		return $item;
	}
	
	public static function save_item_tmp($path, $item, $macAdr=null) {
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		$link = DuneSystem::$properties['tmp_dir_path'] . '/'. $path;
		file_put_contents ($link, $item);
	}
	public static function get_item_tmp($path, $macAdr=null) {
		$item = '';
		if ($macAdr==true)
			$path = $path . self::get_mac_addr(1);
		$link = DuneSystem::$properties['tmp_dir_path'] . '/'. $path;
			if (file_exists($link))
				$item = file_get_contents($link);
		return $item;
	}
	public static function str_remove_tag($str){
		if (preg_match("|(.*?)<font color='green'>Отзывы|ms", $str, $matches))
			$str = $matches[1];
			
		$search = array('@<script[^>]*?>.*?</script>@si',   // Strip out javascript 
                   '@<[\/\!]*?[^<>]*?>@si',                 // Strip out HTML tags 
                   '@<style[^>]*?>.*?</style>@siU',         // Strip style tags properly 
                   '|.*{.*}|'              
        );
		$str = preg_replace($search, '', $str); 
		$str = strip_tags($str);
		$str = str_replace("●","*",$str);
		$str = str_replace("&nbsp;"," ",$str);
		$str = str_replace("&#8211;"," - ",$str);
		$str = str_replace(array("&laquo;","&raquo;"),"'",$str);
		$str = preg_replace("|&#.*?;|", "", $str);
		$str = html_entity_decode($str);
		$str = str_replace('"', "'", $str);
		$str = preg_replace('/\s{2,}/', ' ', $str);
		$str = trim($str);
		return $str;
	}
	
	public static function plugin_version(){
		$xml = simplexml_load_file(DuneSystem::$properties['install_dir_path'].'/dune_plugin.xml');
		return strval($xml->version);
	}
	
	public static function show_size($f,$format=true) 
	{ 
			if($format) 
			{ 
					$size=self::show_size($f,false); 
					if($size<=1024) return $size.' bytes'; 
					else if($size<=1024*1024) return round($size/(1024),2).' Kb'; 
					else if($size<=1024*1024*1024) return round($size/(1024*1024),2).' Mb'; 
					else if($size<=1024*1024*1024*1024) return round($size/(1024*1024*1024),2).' Gb'; 
					else if($size<=1024*1024*1024*1024*1024) return round($size/(1024*1024*1024*1024),2).' Tb'; //:))) 
					else return round($size/(1024*1024*1024*1024*1024),2).' Pb'; // ;-) 
			}else 
			{ 
					if(is_file($f)) 
						return filesize($f); 
					$size=0; 
					$dh=opendir($f); 
					while(($file=readdir($dh))!==false) 
					{ 
							if(($file=='.') || ($file=='..')|| ($file=='') )
								continue;
							if(is_file($f.'/'.$file))
								$size+=filesize($f.'/'.$file); 
							else 
								$size+=self::show_size($f.'/'.$file,false); 
					} 
					closedir($dh); 
					return $size+filesize($f); // +filesize($f) for *nix directories 
			} 
	} 

	public static function isDomainAvailible($domain, $timeout=null){
		if ($timeout==false)
			$timeout=10;
		$curlInit = curl_init($domain);
		curl_setopt($curlInit,CURLOPT_CONNECTTIMEOUT,$timeout);
		if (!preg_match('|/echo$|', $domain)){
			curl_setopt($curlInit,CURLOPT_HEADER,true);
			curl_setopt($curlInit,CURLOPT_NOBODY,true);
		}
		curl_setopt($curlInit,CURLOPT_RETURNTRANSFER,true);
		$response = curl_exec($curlInit);
		curl_close($curlInit);
		if ((preg_match('|/echo$|', $domain))&&($response))
			return $response;
		if ($response) return true;
		return false;
	}
	public static function get_platform_kind(){
		static $platform_kind = null;
		if (is_null($platform_kind))
		{
			$ini_arr = parse_ini_file('/tmp/run/versions.txt');
			if (preg_match('|87\d\d|', $ini_arr['platform_kind']))
				$platform_kind = '87xx';
			if (preg_match('|864\d|', $ini_arr['platform_kind']))
				$platform_kind = '864x';
			if (preg_match('|867\d|', $ini_arr['platform_kind']))
				$platform_kind = '867x';
			if (preg_match('|865\d|', $ini_arr['platform_kind']))
				$platform_kind = '865x';
			if (preg_match('|android|', $ini_arr['platform_kind']))
				$platform_kind = 'android';
			// if ($ini_arr['platform_kind'] == '8758')
				// $dash_platform_kind = true;
			// else
				// $dash_platform_kind = false;
		}
		return $platform_kind;
	}
	public static function get_versions($t=null){
		static $versions = null;
		if (is_null($versions))
            $versions = parse_ini_file('/tmp/run/versions.txt');
		if ($t == true)
			return $versions[$t];
		if (preg_match('|r10|', $versions['firmware_version']))
			return false;
		else if (preg_match('|r1\d|', $versions['firmware_version']))
			return true;
		else
			return false;
    }
	public static function readableBytes($bytes, $bytesEnd=null, $time=null) {
		if ($bytesEnd== true)
			$bytes = ($bytes - $bytesEnd) / $time;
		if (intval($bytes) == 0)
			return '0 B';
		$bytes = floatval($bytes);
		$i = floor(log($bytes) / log(1024));
		$sizes = array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
		return sprintf('%.02F', $bytes / pow(1024, $i)) * 1 . ' ' . $sizes[$i];
	}
}


?>
