#!/bin/sh
ROOT_DIR=`dirname "$0"`;
export PATH="$ROOT_DIR:$PATH"
PLUGIN_INSTALL_DIR_PATH=${ROOT_DIR::${#ROOT_DIR}-4}
PLUGIN_NAME=${PLUGIN_INSTALL_DIR_PATH##*/}
PERSISTFS_DATA_DIR_PATH="/persistfs/plugins_data/$PLUGIN_NAME"
FLASHDATA_DATA_DIR_PATH="/flashdata/plugins_data/$PLUGIN_NAME"
PLUGIN_TMP_DIR_PATH="/tmp/plugins/$PLUGIN_NAME"
if ! [ -f "$ROOT_DIR/rclone" ]; then
	echo '{"status":false,"descr":"rclone bin not found"}' > "$PLUGIN_TMP_DIR_PATH/exec_log"
	exit 25
fi
if [ -d "$PERSISTFS_DATA_DIR_PATH" ]; then              
	PLUGIN_DATA_DIR_PATH="$PERSISTFS_DATA_DIR_PATH"
elif [ -d "$FLASHDATA_DATA_DIR_PATH" ]; then            
    PLUGIN_DATA_DIR_PATH="$FLASHDATA_DATA_DIR_PATH"
else
	echo '{"status":false,"descr":"persistfs not found"}' > "$PLUGIN_TMP_DIR_PATH/exec_log"
	exit 25
fi
if [ -n "$1" ]
then
	if [[ "$1" == "KILL" ]]
	then
		kill $(pgrep -f "rclone rcd")
		exit
	fi
	WEB_GUI_IP="$1"
else
	echo '{"status":false,"descr":"WEB_GUI_IP not found"}' > "$PLUGIN_TMP_DIR_PATH/exec_log"
	exit 25
fi
if [ -n "$2" ]
then
	WEB_GUI_USER_NAME="$2"
else
	echo '{"status":false,"descr":"WEB_GUI_USER_NAME not found"}' > "$PLUGIN_TMP_DIR_PATH/exec_log"
	exit 25
fi
if [ -n "$3" ]
then
	WEB_GUI_PASS="$3"
else
	echo '{"status":false,"descr":"WEB_GUI_PASS not found"}' > "$PLUGIN_TMP_DIR_PATH/exec_log"
	exit 25
fi
CONFIG_FILE_PATH="$PLUGIN_DATA_DIR_PATH/config"
if ! [ -f $CONFIG_FILE_PATH ]; then
	echo '' > "$CONFIG_FILE_PATH"
fi
echo '' > "$PLUGIN_TMP_DIR_PATH/exec_log"
if [ -d "$PERSISTFS_DATA_DIR_PATH" ]; then
	if ! [ -f /etc/ssl/certs/ca-bundle.crt ]; then
		if ! [ -d /etc/ssl ]; then
			mkdir /etc/ssl
		fi
		if [ -d /etc/ssl/certs ]; then
			rm -rf /etc/ssl/certs
		fi
		ln -s /firmware/certs /etc/ssl
	fi
fi
export HOME=$PLUGIN_DATA_DIR_PATH
rclone rcd --rc-web-gui --config "$CONFIG_FILE_PATH" --rc-addr="$WEB_GUI_IP:5572" --rc-user="$WEB_GUI_USER_NAME" --rc-pass="$WEB_GUI_PASS" --log-file="$PLUGIN_TMP_DIR_PATH/exec_log" --ca-cert /firmware/certs/ca-bundle.crt > /dev/null &
