#!/bin/sh

ROOT_DIR=`dirname "$0"`;
export PATH="$ROOT_DIR:/usr/local/bin:$PATH"
PLUGIN_INSTALL_DIR_PATH=${ROOT_DIR::${#ROOT_DIR}-4}
PLUGIN_NAME=${PLUGIN_INSTALL_DIR_PATH##*/}
PLUGIN_DATA_DIR_PATH="/flashdata/plugins_data/$PLUGIN_NAME"
PLUGIN_BIN_DIR_PATH="/flashdata/plugins/$PLUGIN_NAME/bin"
PLUGIN_TMP_DIR_PATH="/tmp/plugins/$PLUGIN_NAME"


if [ -n "$1" ]
then
	REMOTE_NAME="$1"
elif [ -f "$PLUGIN_DATA_DIR_PATH/autostart_remote_name" ]; then
	REMOTE_NAME=$(< "$PLUGIN_DATA_DIR_PATH/autostart_remote_name")
else
	REMOTE_NAME=""
fi
if [[ $REMOTE_NAME == "" ]]; then
	exit
fi

if ! [ -f "$ROOT_DIR/rclone" ]; then
	echo "{\"status\":false,\"descr\":\"Ошибка; Не найден файл <rclone>\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
	exit
fi
if ! [ -f "$ROOT_DIR/fusermount" ]; then
	echo "{\"status\":false,\"descr\":\"Ошибка; Не найден файл <fusermount>\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
	exit
fi

if ! [ -n "$2" ] ; then
	if [ -f "$PLUGIN_DATA_DIR_PATH/cache_dir_path" ]; then
		CACHE_DIR=$(< "$PLUGIN_DATA_DIR_PATH/cache_dir_path")
	else
		echo "{\"status\":false,\"descr\":\"Ошибка; Не найден файл <cache_dir_path>\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
		exit
	fi
	if ! [ -d "$CACHE_DIR" ]; then
		CACHE_DIR=$PLUGIN_DATA_DIR_PATH
		echo "{\"status\":false,\"descr\":\"Предупреждение; НЕТ ранее указанного накопителя для кэш, временно используется 'FLASHdata' \"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
	fi
	CACHE_DIR=$(echo $CACHE_DIR'/Rclone_cache')
	mkdir -p "$CACHE_DIR"

	if [ -f "$PLUGIN_DATA_DIR_PATH/no_ports" ]; then
		NO_PORT=$(< "$PLUGIN_DATA_DIR_PATH/no_ports")
	else
		NO_PORT=''   # список номеров зарезервированных портов, лучше разделить любым символом 
	fi
fi

#???
if ! [ -e /dev/fuse ]; then
	modprobe fuse
	[ -e /dev/fuse ] || mknod /dev/fuse c 10 229
fi
#???

FUSE_MOUNT_DIR_PATH="/mnt/runtime/default/emulated/0/DuneHD"
#FUSE_MOUNT_DIR_PATH="/sdcard/DuneHD/"
CONFIG_FILE_PATH="$PLUGIN_DATA_DIR_PATH/config"

####################### Поиск пути к каталогу на внешенем накопителе
PATH_1="/mnt/runtime/default"
PATH_2="RCLONE"
COPY_MOUNT_DIR_PATH=""
for i in $(ls $PATH_1 | grep -v 'udisk')
do
	if ! ( [[ $i == 'self' ]] || [[ $i == 'emulated' ]] ) ; then
		if [ -d "$PATH_1/$i/$PATH_2" ]; then
#echo "{\"status\":false,\"descr\":\"Подходящий накопитель: $i\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
			for i1 in $(ls "$PATH_1/$i")
			do
				if ( [[ $i1 ==  $PATH_2 ]] ) ; then
					COPY_MOUNT_DIR_PATH=$(echo "$PATH_1/$i/$PATH_2")
					break 2
				fi
			done
			if [[ $COPY_MOUNT_DIR_PATH == '' ]] ; then	# если монтирование на внешний накопитель
				echo "{\"status\":false,\"descr\":\"Ошибка на внешнем накопителе: $i;Написание имени папки для копии монтирований не соответствует: $PATH_2^Необходимо удалить папку и создать заново с правильным регистром символов\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
				exit
			fi
		fi
	fi
done
#echo "{\"status\":false,\"descr\":\"Путь на внешнем накопителе:$COPY_MOUNT_DIR_PATH\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
if ! ( [[ $COPY_MOUNT_DIR_PATH == '' ]] ); then 	
	if ! ([ `ls -d $PATH_1/*/$PATH_2 | grep -v 'udisk' | wc -w` -eq 1 ]) ; then 	
		echo "{\"status\":false,\"descr\":\"Ошибка; Папка $PATH_2 более чем на одном накопителе, необходимо оставить только на одном. \"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
		exit 
	fi
fi
#######################

rc_port_end=5600
rc_port=5572

REMOTE_NAME_IN=$(echo $(echo $REMOTE_NAME | tr " " "*") | tr "," " ")
for REMOTE_NAME_TMP in $REMOTE_NAME_IN
do
	REMOTE_NAME=$(echo $REMOTE_NAME_TMP | tr "*" " ")

	PS_TMP=$(echo $(ps w | grep "rclone mount" | grep 127.0.0.1:))

	if ! [ -n "$2" ] ; then
		if ! [[ $PS_TMP == *'mount '$REMOTE_NAME':'* ]]; then # Проверка на факт повторного монтирования

			while :
			do
				rc_port=$(($rc_port + 1))
				if ! [ $rc_port -lt $rc_port_end ]; then
					echo "{\"status\":false,\"descr\":\"Ошибка; Для $REMOTE_NAME: нет свободных портов для RC \"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
					exit
				fi
				if ! [[ $PS_TMP == *127.0.0.1:$rc_port* ]]; then
					if ! [[ $NO_PORT == *$rc_port* ]]  ; then
						break
					fi
				fi
			done


			if ! [[ $NO_PORT == *'-cache'* ]]  ; then
				echo 127.0.0.1:$rc_port >> "$PLUGIN_DATA_DIR_PATH/rc_port_cache_jobs"
			fi

			#rm -Rf "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"                # удаление каталога перед созданием и монтированием
			if ! [ -d "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME" ]; then
				mkdir -p "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"
			fi
			if ! [ `ls "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME" | wc -l` -eq 0 ]; then 	
				echo "{\"status\":false,\"descr\":\"Ошибка монтирования; Папка '$REMOTE_NAME' во внутренней памяти не пустая \"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
				exit
			fi

			if [ -f "$PLUGIN_DATA_DIR_PATH/settings_$REMOTE_NAME" ]; then
				STR_SETUP=$(< "$PLUGIN_DATA_DIR_PATH/settings_$REMOTE_NAME")
			else
				if [ -f "$PLUGIN_DATA_DIR_PATH/settings" ]; then
					STR_SETUP=$(< "$PLUGIN_DATA_DIR_PATH/settings")
				else
					echo "{\"status\":false,\"descr\":\"Предупреждение; Для $REMOTE_NAME: не найден файл с настройками, используется 'минимальный' вариант\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
				fi
			fi

			STR_START=$(echo \
			rclone mount "'$REMOTE_NAME'": \
			--rc-addr 127.0.0.1:$rc_port --rc \
			"'$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME'" \
			--allow-other \
			--daemon \
			--config "$CONFIG_FILE_PATH" \
			--cache-dir "$CACHE_DIR" \
			--vfs-cache-max-age 675h \
			--dir-cache-time 672h \
			"$STR_SETUP")

			eval $STR_START &>/dev/null

			if ! [ -f "$PLUGIN_TMP_DIR_PATH/my_exec_log" ]; then
				echo "{\"status\":true,\"descr\":\"dump; $STR_START\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
			fi	

			if ! [[ $COPY_MOUNT_DIR_PATH == '' ]] ; then	# если монтирование на внешний накопитель
				if ! [ -d "$COPY_MOUNT_DIR_PATH/$REMOTE_NAME" ]; then
#					echo "{\"status\":false,\"descr\":\"Создание папки на внешнем накопителе:$COPY_MOUNT_DIR_PATH/$REMOTE_NAME\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
					mkdir -p "$COPY_MOUNT_DIR_PATH/$REMOTE_NAME"
				fi
				umount "$COPY_MOUNT_DIR_PATH/$REMOTE_NAME"
#				echo "{\"status\":false,\"descr\":\"Монтирование на внешнем накопителе:$COPY_MOUNT_DIR_PATH/$REMOTE_NAME\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
				sleep 0.5
				mount "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME" "$COPY_MOUNT_DIR_PATH/$REMOTE_NAME"
			fi
		fi
	else

		if [[ "$2" == "UMOUNT" ]] ; then
			`fusermount -u "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"`
#			fusermount -u "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"
#			umount "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"
#			umount -l "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"
#			umount -f "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"
#			umount -d "$FUSE_MOUNT_DIR_PATH/$REMOTE_NAME"
		fi
		if [[ "$2" == "KILL" ]]  ; then
			kill $(pgrep -f "rclone mount $REMOTE_NAME:")
		fi
		if [[ "$2" == "UMOUNT" ]] || [[ "$2" == "KILL" ]]  ; then
			sleep 0.5
			if ! [[ $COPY_MOUNT_DIR_PATH == '' ]] ; then	# если монтирование на внешний накопитель
#				echo "{\"status\":false,\"descr\":\"Разонтирование на внешнем накопителе:$COPY_MOUNT_DIR_PATH/$REMOTE_NAME\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
				umount "$COPY_MOUNT_DIR_PATH/$REMOTE_NAME"
				sleep 0
			fi
		fi

		if [[ "$2" == "EXT_PATH" ]]  ; then
			PATH_3="tmp/mnt/storage"
			if ( [ `ls -d $PATH_3/*/$PATH_2 | grep -v 'udisk' | wc -w` -eq 1 ] ) ; then 	
				echo `ls -d $PATH_3/*/$PATH_2 | grep -v 'udisk' | awk -F'/' '{print $4}'` | tr -d '\r\n'
#				echo "{\"status\":false,\"descr\":\"Путь; -$COPY_MOUNT_DIR_PATH- \"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
			fi
		fi

		if [[ "$2" == "INFO_OPEN_FILES" ]]  ; then
			I_info=`lsof | grep "/$REMOTE_NAME/" | tr -s '\r\n' '^^'`
			if  [[ "$I_info" == "" ]]  ; then
				I_info="Нет открытых файлов^^"
			fi
			I_info=$(echo $I_info | tr -d '\r\n' )
			echo "{\"status\":false,\"descr\":\"Процессы с открытыми файлами на: $REMOTE_NAME   (выборка по подстроке /$REMOTE_NAME/ );$I_info\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
		fi

		if [[ "$2" == "INFO_SIZE" ]]  ; then
			$PLUGIN_BIN_DIR_PATH/rclone_info.sh "$REMOTE_NAME" &
		fi

		if [[ "$2" == "INFO_?" ]]  ; then

			I_pid=$(pgrep -f "rclone mount $REMOTE_NAME:")

			I_ps=$(ps w | grep 'rclone ' | grep "mount $REMOTE_NAME:")

			I_lsof=$(lsof | grep "/$REMOTE_NAME/")		
#			I_lsof=$(echo $I_lsof | grep /storage/)		
#			I_lsof=${I_lsof#*/}
#echo ${v%:*} # убрать всё после последнего двоеточия
#echo ${v#*:} # убрать всё до первого двоеточия

			I_mount=`mount | grep "/$REMOTE_NAME" | tr -s '\r\n' '~~'`

			I_info=$(echo " <pgrep -f 'rclone mount $REMOTE_NAME:'>: ~ $I_pid ~~
			<ps w | grep 'rclone ' | grep 'mount $REMOTE_NAME:'>: ~ $I_ps ~~
			<lsof | grep '$REMOTE_NAME'>: ~ $I_lsof ~~
			<mount | grep '$REMOTE_NAME'>: ~ $I_mount")

#			I_info=$(echo $I_info | tr -d '\r\n' )
			I_info=$(echo $I_info | tr '\r\n' '~')
			echo "{\"status\":false,\"descr\":\"info- $REMOTE_NAME:$I_info\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
		fi
	fi
done
if ! [ -n "$2" ] ; then
	sleep 2
fi
