#!/bin/sh
ROOT_DIR=`dirname "$0"`;
export PATH="$ROOT_DIR:/usr/local/bin:$PATH"
PLUGIN_INSTALL_DIR_PATH=${ROOT_DIR::${#ROOT_DIR}-4}
PLUGIN_NAME=${PLUGIN_INSTALL_DIR_PATH##*/}
PLUGIN_DATA_DIR_PATH="/flashdata/plugins_data/$PLUGIN_NAME"
PLUGIN_BIN_DIR_PATH="/flashdata/plugins/$PLUGIN_NAME/bin"
PLUGIN_TMP_DIR_PATH="/tmp/plugins/$PLUGIN_NAME"

REMOTE_NAME="$1"
CONFIG_FILE_PATH="$PLUGIN_DATA_DIR_PATH/config"

if ! (ps w | grep 'rclone ' | grep 'size '"$REMOTE_NAME"':' ); then	# проверка наличия уже такой же работающей задачи
	cloud_info=$(rclone size "$REMOTE_NAME": --config "$CONFIG_FILE_PATH")
	cloud_info=${cloud_info/Total objects/Объектов}
	cloud_info=${cloud_info/Total size/^Объем}
	cloud_info=$(echo $cloud_info | tr '\r\n' '^^')
	cloud_info=$(echo $cloud_info | tr -d '\r\n' )
	echo "{\"status\":false,\"descr\":\"Размер: $REMOTE_NAME ; $cloud_info\"}" > "$PLUGIN_TMP_DIR_PATH/my_exec_log"
fi	
