#!/bin/sh
if ! [[ $(pidof -s rclone_cache.sh) == $(pidof rclone_cache.sh) ]]  ; then			# защита от повторного запуска
	exit
fi
ROOT_DIR=`dirname "$0"`;
export PATH="$ROOT_DIR:/usr/local/bin:$PATH"
PLUGIN_INSTALL_DIR_PATH=${ROOT_DIR::${#ROOT_DIR}-4}
PLUGIN_NAME=${PLUGIN_INSTALL_DIR_PATH##*/}
PLUGIN_DATA_DIR_PATH="/flashdata/plugins_data/$PLUGIN_NAME"
PLUGIN_BIN_DIR_PATH="/flashdata/plugins/$PLUGIN_NAME/bin"
PLUGIN_TMP_DIR_PATH="/tmp/plugins/$PLUGIN_NAME"
CONFIG_FILE_PATH="$PLUGIN_DATA_DIR_PATH/config"

chmod -R 777 /flashdata/plugins/rclone
chmod -R 777 /flashdata/plugins_data/rclone

my_ping(){
	if $(pidof com.psiphon3.subscription  > /dev/null ) ; then
#	if ( ps w | grep 'psi' | grep 'phon' > /dev/null ) ; then
		if wget -s -T 1 'google.com' > /dev/null ; then	# проверка наличия интернета
			echo 
		else
			echo 0
		fi
	else
		if ping -q -w 1 -c 1 'yandex.ru' > /dev/null ; then	# проверка наличия интернета
			echo 
		else
			echo 0
		fi
	fi
}

TMP_CACHE_TIMES="--:--"					# tmp время автокэширования 

INTERVAL_SYNC=86400						# интревал в секндах запуска скрипта копирования
COUNT=1									# счетчик для запуска скрипта коирования

while true
do
	if [ -f "$PLUGIN_DATA_DIR_PATH/rc_port_cache_jobs" ] ; then													# есть задания на кэширование
		if !( ps w | grep rclone | grep _mount.sh ); then														# работает если НЕ запущен скрипт rclone_mount.sh
			RC_LIST=$(< "$PLUGIN_DATA_DIR_PATH/rc_port_cache_jobs")
			if $(my_ping) ; then																				# проверка наличия интернета
				RC_TMP=""																						# ошибкИ запуска кэширования
				for rc_adr in $RC_LIST
				do
					if ( echo "$rc_adr" | grep '127.0.0.1' && [[ ${#rc_adr} == 14 ]] ) ; then					# проверка адрес ли это
						if ! (ps w | grep 'rclone ' | grep "vfs/refresh recursive=true --rc-addr "$rc_adr ); then	# проверка наличия работающего кэширования
							if $(my_ping) ; then																# проверка наличия интернета
								rclone rc vfs/refresh recursive=true --rc-addr $rc_adr &>/dev/null &
							else
								RC_TMP=$(echo $RC_TMP $rc_adr)
							fi	
						fi	
					fi	
				done
				rm "$PLUGIN_DATA_DIR_PATH/rc_port_cache_jobs"
				if ! [[ $RC_TMP == "" ]] ; then
					echo $RC_TMP > "$PLUGIN_DATA_DIR_PATH/rc_port_cache_jobs"									# запись ошибок запуска кэширования
				fi
			
			fi
		fi
	fi
# автокэширование (постановка задачи)
	if [[ $TMP_CACHE_TIMES != $(date +"%H:%M") ]] ; then
		TMP_CACHE_TIMES=$(date +"%H:%M")
		AUTO_CACHE_TIMES="05:00"
		if [ -f "$PLUGIN_DATA_DIR_PATH/no_ports" ]; then
			AUTO_CACHE_TIMES=`echo $AUTO_CACHE_TIMES $(< "$PLUGIN_DATA_DIR_PATH/no_ports")`
		fi
		if [[ $AUTO_CACHE_TIMES == *$(date +"%H:%M")* ]] ; then
			if $(my_ping) ; then	# проверка наличия интернета
				ps w | grep 'rclone ' | grep mount | grep '127.0.0.1' > "$PLUGIN_DATA_DIR_PATH/rc_port_cache_jobs"
			fi
		fi
	fi

# запуск скрипта копирования
	COUNT=$(( $COUNT + 1 ))
	if (( $COUNT > $INTERVAL_SYNC ))  ; then
		if [ -f "$PLUGIN_BIN_DIR_PATH/rclone_sync.sh" ] ; then
			if $(my_ping) ; then	# проверка наличия интернета
				$PLUGIN_BIN_DIR_PATH/rclone_sync.sh 'rclone_cache.sh' &
			fi	
		fi	
		COUNT=1
	fi
	sleep 1
done
