#!/bin/sh
if ! [[ $(pidof -s mem_available.sh) == $(pidof mem_available.sh) ]]  ; then			# защита от повторного запуска
	exit
fi

WMARK_LOW_PAGES=`grep -A3 Node /proc/zoneinfo | awk '$1=="low" {sum+=$2}; END {print sum}'`
let WMARK_LOW=WMARK_LOW_PAGES*4			# pagesize=4KB

MEM_FREE=`awk '$1=="MemFree:" {print $2}' /proc/meminfo`
let MEM_AVAIL=MEM_FREE-WMARK_LOW

LRU_ACTIVE_FILE=`awk '$1=="Active(file):" {print $2}' /proc/meminfo`
LRU_INACTIVE_FILE=`awk '$1=="Inactive(file):" {print $2}' /proc/meminfo`

let PAGE_CACHE=LRU_ACTIVE_FILE+LRU_INACTIVE_FILE
let TMP=PAGE_CACHE/2
if [ ${TMP} -lt ${WMARK_LOW} ]; then
    let PAGE_CACHE-=TMP
else
    let PAGE_CACHE-=WMARK_LOW
fi
let MEM_AVAIL+=PAGE_CACHE

SLAB_RECLAIMABLE=`awk '$1=="SReclaimable:" {print $2}' /proc/meminfo`
let TMP=SLAB_RECLAIMABLE/2
if [ ${TMP} -lt ${WMARK_LOW} ]; then
    let SLAB_RECLAIMABLE-=TMP
else
    let SLAB_RECLAIMABLE-=WMARK_LOW
fi
let MEM_AVAIL+=SLAB_RECLAIMABLE

[ ${MEM_AVAIL} -lt 0 ] && MEM_AVAIL=0

freeMem=$MEM_AVAIL
#freeMem=`egrep "MemFree" /proc/meminfo | cut -d':' -f 2 | sed -e 's/^[ \t]*//' | cut -d' ' -f 1`

totalMem=`egrep "MemTotal" /proc/meminfo | cut -d':' -f 2 | sed -e 's/^[ \t]*//' | cut -d' ' -f 1`

freePerc=$((($freeMem*1000+($totalMem/2))/$totalMem))
echo "$freePerc" > '/flashdata/plugins_data/rclone/memory_info'
echo $(free) > '/flashdata/plugins_data/rclone/memory_info2'
