<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_controls_screen.php';

///////////////////////////////////////////////////////////////////////////

class SmartSetupScreen extends AbstractControlsScreen
{
    const ID = 'setup';
	private $platform = null;
	private $install_dir = null;
	private $counter = 0;
	private $listCounter = 0;
	private $execLogObj = 0;
    ///////////////////////////////////////////////////////////////////////

    public function __construct(){
        parent::__construct(self::ID);
    }

    public function do_get_control_defs(&$plugin_cookies){
        $config_array = $defs = array();
        if ((file_exists('/persistfs'))||(HD::get_platform_kind() == 'android')){
			$caption = "необходимо добавить подключения через WEB GUI";
			$caption2 = 'или через импорт rclone.conf';
			if ((file_exists('/persistfs/plugins_data/'.DuneSystem::$properties['plugin_name'].'/config'))||
			((HD::get_platform_kind() == 'android')&&(file_exists('/flashdata/plugins_data/'.DuneSystem::$properties['plugin_name'].'/config')))){
				$config_array = parse_ini_file(DuneSystem::$properties['data_dir_path'] .'/config', true, INI_SCANNER_RAW);
				echo "remotes count:" . count($config_array);
				if (count($config_array) > 0){
					ControlFactory::add_button ($defs, $this, null, 'remotes_list', "Список доступных подключений: " . count($config_array), 'Открыть', 200);
					$caption = "Добавить или удалить подключения через WEB GUI";
					$caption2 = "При импорте файл конфигурации перезаписывается";
				}else
					ControlFactory::add_label($defs, "Доступных подключений не найдено,", '');
			}else
				ControlFactory::add_label($defs, "Доступных подключений не найдено,", '');
			$this->add_button($defs,
				'web_gui', 
				$caption,
				'Запустить WEB GUI', 500
			);
			$this->add_button($defs,
				'import_conf', 
				$caption2,
				'Импорт файла rclone.conf', 500
			);
			$rclone_mount = SmartConfig::rclone_mount();
			if ($rclone_mount == true){
				if (preg_match('|mount\s+(.+?):\s+(.+?)-|', $rclone_mount, $matches)){
					$type = 'n/a';
					if (isset($config_array[trim($matches[1])]['type']))
						$type = $config_array[trim($matches[1])]['type'];
					$remote_name = trim($matches[1]);
					ControlFactory::add_label($defs, "Запущено: $remote_name " . str_repeat("_", (33 - strlen($remote_name))), '__________________________');
					$add_params ['mount_path'] = trim($matches[1]);
					ControlFactory::add_button ($defs, $this, $add_params, 'remote_open', "Тип подключения: " .$type, 'Открыть в Файловом браузере', 200);
					$add_params ['mount_path'] = trim($matches[2]);
					$inf_srt = "Смонтированно: " . $add_params ['mount_path'];
					ControlFactory::add_button ($defs, $this, $add_params, 'remote_stop', $inf_srt, 'Остановить', 200);
					ControlFactory::add_button ($defs, $this, $add_params, 'remote_info', '', 'Информация', 200);
				}
				ControlFactory::add_vgap($defs, -20);
			}
			$autostart_remote_name = SmartConfig::get_autostart_remote_name();
			if (isset($autostart_remote_name['remote_name'])){
				$remote_name = $autostart_remote_name['remote_name'];
				$Info='Включение плеера';
				if ($autostart_remote_name['type'] == 2)
					$Info='Вход в плагин';
				$type = 'n/a';
				if (isset($config_array[$remote_name]['type']))
					$type = $config_array[$remote_name]['type'];
				ControlFactory::add_label($defs, "Автозапуск: $remote_name " . str_repeat("_", (31 - strlen($remote_name))), '__________________________');
				ControlFactory::add_vgap($defs, -10);
				ControlFactory::add_button ($defs, $this, null, 'autostart_remove', "$Info Тип: " .$type, 'Отмена автозапуска', 200);
				ControlFactory::add_vgap($defs, -30);
					
			}else if (count($config_array) > 0){
				ControlFactory::add_label($defs, "Автозапуск: нет____________________________", '__________________________');
				ControlFactory::add_vgap($defs, -10);
				$add_params ['list'] = 1;
				ControlFactory::add_button ($defs, $this, $add_params, 'autostart_add', "Добавить подключение в автозапуск", 'Добавить', 200);
				ControlFactory::add_vgap($defs, -30);
			}
		}else
			ControlFactory::add_multiline_label($defs, "", 'Для работы плагина необходим системный накопитель. Инициализируйте системный накопитель.', 4);
		
		ControlFactory::add_label($defs, "___________________________________________", '__________________________');
		
		$this->add_button($defs,
			'whats_new', 
			"Изменения в v".HD::plugin_version(),
			'Показать', 500
		);
		if (file_exists('/persistfs')){
			ControlFactory::add_vgap($defs, 25);
			ControlFactory::add_smart_label($defs, "", 
				'<text color="10" size="small">Системная флешка: </text><text color="15" size="small">'.HD::get_storage_size('/persistfs').'</text>'
			);
		}else if (HD::get_platform_kind() == 'android'){
			ControlFactory::add_vgap($defs, 25);
			ControlFactory::add_smart_label($defs, "", 
				'<text color="10" size="small">FLASHdata: </text><text color="15" size="small">'.HD::get_storage_size('/flashdata').'</text>'
			);
		}
        return $defs;
    }

    public function get_control_defs(MediaURL $media_url, &$plugin_cookies){
        return $this->do_get_control_defs($plugin_cookies);
    }
	public function do_exec_log(){
		$exec_log = file_get_contents(DuneSystem::$properties['tmp_dir_path'].'/exec_log');
		$execLogObj = json_decode($exec_log);
		if (is_object($execLogObj))
			foreach ($execLogObj as $key => $value)
				hd_print("  $key => $value");
		else{
#			hd_print ("  str: " . $exec_log);
			$execLogObj = (object)array('descr'=> 1);
			$execLogObj->descr = $exec_log;
		}
		$this->execLogObj = $execLogObj;
    }
    public function handle_user_input(&$user_input, &$plugin_cookies){
        $attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'remotes_list'){
			return ActionFactory::open_folder(SmartListScreen::get_media_url_str(), 'Список доступных подключений');
		}
		if ($user_input->control_id == 'import_conf'){
			$media_url = MediaURL::encode (
				array(
					'screen_id'     => 'file_list',
					'save_file'		=> array(	
					'parent' => self::ID,
					'action' => 'import_conf',
					'extension' => 'conf'
					),
				)
			);
			return ActionFactory::open_folder($media_url, 'Импорт файла rclone.conf');
		}
		if ($user_input->control_id == 'autostart_add'){
			$defs = array();
			$caption = '';
			if (isset($user_input->autostart_remote))
				$caption = ': ' . $user_input->autostart_remote;
			if ((isset($user_input->action))&&($user_input->action == 'setup_remote')){
				if (file_exists('/persistfs'))
					$cache_ops[DuneSystem::$properties['data_dir_path']] = 'Системный накопитель' . ' (' . HD::get_storage_size('/persistfs') .')';
				else if (file_exists('/flashdata'))
					$cache_ops[DuneSystem::$properties['data_dir_path']] = 'FLASHdata' . ' (' . HD::get_storage_size('/flashdata') .')';
				foreach (glob('/tmp/mnt/storage/*') as $file)
					if (is_dir($file))
						$cache_ops[$file] = substr($file,17,strlen($file)) . ' (' . HD::get_storage_size($file) .')';
				ControlFactory::add_multiline_label($defs, '', 'Расположение кеша rclone в который загружаются файлы для операций чтения записи с облачных сервисов.', 8);
				$cache_dir = (HD::get_item('autostart_cache_dir_path') !='') ? HD::get_item('autostart_cache_dir_path') : DuneSystem::$properties['data_dir_path'];
				if ($cache_dir != DuneSystem::$properties['data_dir_path'])
					$cache_dir = str_replace('/' .DuneSystem::$properties['plugin_name'], '', $cache_dir);
				ControlFactory::add_combobox($defs, $this, null,
					'cache_dir', '',
					$cache_dir, $cache_ops, 900, false, false
				);
				$add_params ['autostart_type'] = $user_input->autostart_type;
				$add_params ['autostart_remote'] = $user_input->autostart_remote;
				$add_params ['action'] = 'setup_remote21';
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, $user_input->control_id, 'Далее', 550);
			}
			if ((isset($user_input->action))&&($user_input->action == 'setup_remote21')){
				ControlFactory::add_multiline_label($defs, '', "Способ работы кеша rclone в который загружаются файлы для операций чтения записи с облачных сервисов.\nПри настройке \"writes\" файлы загружаются в кеш только при записи в файл, а при чтении нет.\n При настройке \"full\" файлы загружаются в кеш и при чтении и при записи, этот способ рекомендуется при хранении папок Data плагинов в облачных сервисах.", 11);
				$vfs_cache_mode_ops["writes"] = "writes";
				$vfs_cache_mode_ops["full"] = "full";
				$vfs_cache_mode_ops["readOnly"] = "Только чтение";
				$vfs_cache_mode = (HD::get_item('autostart_vfs_cache_mode') !='') ? HD::get_item('autostart_vfs_cache_mode') : "writes";
				if (!file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_write_mode'))
					$vfs_cache_mode = "readOnly";
				
				ControlFactory::add_combobox($defs, $this, null,
					'vfs_cache_mode', '',
					$vfs_cache_mode, $vfs_cache_mode_ops, 400, false, false
				);
				$add_params ['autostart_type'] = $user_input->autostart_type;
				$add_params ['autostart_remote'] = $user_input->autostart_remote;
				$add_params ['cache_dir'] = $user_input->cache_dir;
				$add_params ['action'] = 'setup_remote22';
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, $user_input->control_id, 'Далее', 250);
			}
			if ((isset($user_input->action))&&($user_input->action == 'setup_remote22')){
				$vfs_read_chunk_size = (HD::get_item('autostart_vfs_read_chunk_size') !='') ? HD::get_item('autostart_vfs_read_chunk_size') : "32M";
				for ($i = 1; $i<65; $i=$i*2)
					$size_ops[$i.'M'] = $i.'MB';
				ControlFactory::add_multiline_label($defs, '', "Размер частей чтения файлов", 11);
				ControlFactory::add_combobox($defs, $this, null,
					'vfs_read_chunk_size', '',
					$vfs_read_chunk_size, $size_ops, 400, false, false
				);
				ControlFactory::add_multiline_label($defs, '', "Размер буффера", 11);
				$buffer_size = (HD::get_item('autostart_buffer_size') !='') ? HD::get_item('autostart_buffer_size') : "16M";
				ControlFactory::add_combobox($defs, $this, null,
					'buffer_size', '',
					$buffer_size, $size_ops, 400, false, false
				);
				$add_params ['vfs_cache_mode'] = $user_input->vfs_cache_mode;
				$add_params ['autostart_type'] = $user_input->autostart_type;
				$add_params ['autostart_remote'] = $user_input->autostart_remote;
				$add_params ['cache_dir'] = $user_input->cache_dir;
				$add_params ['action'] = 'setup_remote2';
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, $user_input->control_id, 'Далее', 250);
			}
			if ((isset($user_input->action))&&($user_input->action == 'setup_remote2')){
				ControlFactory::add_multiline_label($defs, '', 'Максимальный размер кеша rclone в который загружаются файлы для операций чтения записи с облачных сервисов. Обратите внимание, что кэш может превышать этот размер по некоторым причинам.', 8);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="small">'.$user_input->cache_dir.' </text><text color="15" size="small">('.HD::get_storage_size($user_input->cache_dir).')</text>'
				);
				$cache_max_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_cache_max_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_cache_max_size')) : "32M";
				$cache_size_unit = substr($cache_max_size, -1);
				$cache_max_size = substr($cache_max_size, 0, -1);
				ControlFactory::add_text_field($defs, $this, null,
					'cache_max_size',
					'',
					$cache_max_size, 1, 0, 0, 1, 400, 1, 1
				);
				$cache_size_unit_ops['M'] = 'MB';
				$cache_size_unit_ops['G'] = 'GB';
				ControlFactory::add_combobox($defs, $this, null,
					'cache_size_unit', '',
					$cache_size_unit, $cache_size_unit_ops, 400, false, false
				);
				$add_params ['vfs_read_chunk_size'] = $user_input->vfs_read_chunk_size;
				$add_params ['buffer_size'] = $user_input->buffer_size;
				$add_params ['vfs_cache_mode'] = $user_input->vfs_cache_mode;
				$add_params ['autostart_type'] = $user_input->autostart_type;
				$add_params ['autostart_remote'] = $user_input->autostart_remote;
				$add_params ['cache_dir'] = $user_input->cache_dir;
				$add_params ['action'] = 'setup_end';
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, $user_input->control_id, 'Далее', 550);
			}
			if ((isset($user_input->action))&&($user_input->action == 'setup_end')){
				if (isset($user_input->cache_dir))
					$user_input->cache_dir = SmartConfig::save_cache_dir_path($user_input->cache_dir);
				if (isset($user_input->cache_max_size))
					SmartConfig::save_cache_max_size($user_input->cache_max_size . $user_input->cache_size_unit);
				SmartConfig::save_autostart_remote($user_input->autostart_remote, $user_input->autostart_type);
				if (isset($user_input->vfs_cache_mode)){
					if ($user_input->vfs_cache_mode == 'readOnly'){
						$user_input->vfs_cache_mode = 'writes';
						if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_write_mode'))
							unlink (DuneSystem::$properties['data_dir_path'] . '/autostart_write_mode');
					}else
						HD::save_item('autostart_write_mode', 1);
					HD::save_item('autostart_vfs_cache_mode', $user_input->vfs_cache_mode);
				}
				if (isset($user_input->vfs_read_chunk_size))
					HD::save_item('autostart_vfs_read_chunk_size', $user_input->vfs_read_chunk_size);
				if (isset($user_input->buffer_size))
					HD::save_item('autostart_buffer_size', $user_input->buffer_size);
				return ActionFactory::invalidate_folders(array($user_input->parent_media_url));
			}
			if (isset($user_input->list)){
				ControlFactory::add_multiline_label($defs, '', "Выберите подключение для автозапуска:", 8);
				$config_array = parse_ini_file(DuneSystem::$properties['data_dir_path'] .'/config', true, INI_SCANNER_RAW);
				foreach ($config_array as $k => $v)
					$autostart_ops[$k] = $k;
				ControlFactory::add_combobox($defs, $this, null,
					'autostart_remote', '',
					'', $autostart_ops, 950, false, false
				);
				$autostart_type_ops[1]='Запуск при включении плеера';
				$autostart_type_ops[2]='Запуск при входе в плагин';
				ControlFactory::add_combobox($defs, $this, null,
					'autostart_type', '',
					1, $autostart_type_ops, 950, false, false
				);
				$add_params ['action'] = 'setup_end';
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, $user_input->control_id, 'Сохранить', 550);
				$add_params ['action'] = 'setup_remote';
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, $user_input->control_id, 'Настроть и сохранить', 550);
				ControlFactory::add_vgap($defs, -15);
				ControlFactory::add_smart_label($defs, "", 
					'<text size="small">*Настройки общие для всех подключений.</text>'
				);
				$defs = SmartConfig::get_info_defs ($defs);
			}
			return ActionFactory::show_dialog("Автозапуск" . $caption, $defs, true, 1000, $attrs);
		}
		if ($user_input->control_id == 'autostart_remove'){
			SmartConfig::autostart_remove ();
			return ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
		}
		if ($user_input->control_id == 'remote_info'){
			$defs = array();
			$defs = SmartConfig::get_remote_info_defs($defs);
			return ActionFactory::show_dialog("Информация о текущем подключении", $defs, true, 1000, $attrs);
		}
		if ($user_input->control_id == 'remote_stop'){
			if (isset($user_input->mount_path)){
				SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/rclone_kill.sh umount \"" . $user_input->mount_path . '"');
				$this->do_exec_log();
				if ((isset($this->execLogObj->status))&&($this->execLogObj->status === false))
					$caption = 'Error!';
				else if ((isset($this->execLogObj->status))&&($this->execLogObj->status === true))
					$caption = 'Остановлено';
				$descr = $this->execLogObj->descr;
			}else
				$descr = 'mount_path не указан';
			$action = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
			return ActionFactory::show_title_dialog($caption, $action, $descr, 600, 1);
		}
		if ($user_input->control_id == 'remote_open'){
			return SmartConfig::remote_open($user_input->mount_path);
		}
		if ($user_input->control_id == 'web_gui'){
			$ip_address = 'http://' .HD::get_ip_address().':5572';
			$login_settings = HD::get_items('login_settings');
			$user_login = isset($login_settings['user_login']) ? $login_settings['user_login'] : 'admin';
			$user_pass = isset($login_settings['user_pass']) ? $login_settings['user_pass'] : 'admin';
			if ((SmartConfig::rclone_rcd () == true)&&(!isset($user_input->get_stop)))
				$user_input->get_started = 1;
			if (isset($user_input->get_start)){
				if ($this->counter == 0)
					SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/rclone_rcdstart.sh ". HD::get_ip_address() ." $user_login $user_pass");			
				$this->counter++;
				$this->do_exec_log();
				if ((isset($this->execLogObj->status))&&($this->execLogObj->status === false)){
					$action = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
					return ActionFactory::show_title_dialog('Error!', $action, $this->execLogObj->descr, 600, 1);
				}
				ControlFactory::add_label($defs, '', "Прошло ".HD::sec_format_duration($this->counter)." сек.");
				if (HD::isDomainAvailible($ip_address, 1) == true){
					$add_params ['get_started'] = true;
				}else if ($this->counter > 120){
					$action = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
					return ActionFactory::show_title_dialog('Error!', $action, $this->execLogObj->descr, 600, 1);
				}else{
					$add_params ['get_start'] = true;
					ControlFactory::add_label($defs, '', 'Запуск' . str_repeat(".", $this->counter));
				}
				ControlFactory::add_multiline_label($defs, '', $this->execLogObj->descr, 10);
				$action = UserInputHandlerRegistry::create_action($this, 'web_gui', $add_params);
				$attrs['timer'] = ActionFactory::timer(1000);
				$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($action));
				$caption = 'Запуск WEB GUI';
				$return = false;
			}else if (isset($user_input->get_started)){
				$this->counter = 0;
				$add_params ['get_stop'] = true;
				ControlFactory::add_close_dialog_and_apply_button(&$defs, $this, $add_params, 'web_gui', 'Остановить WEB GUI', 450);
				
				$txt='WEB GUI запущен. Откройте указанный ниже адрес в браузере на любом устройстве:';
				ControlFactory::add_multiline_label($defs, '', $txt, 10);
				ControlFactory::add_vgap($defs, -10);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">' .$ip_address.'</text>'
				);
				$qr_params['qr_str'] = $ip_address;
				ControlFactory::add_button(&$defs, $this, $qr_params, 'show_qr', '', 'QR code', 450);
				$txt='После настройки rclone остановите WEB GUI';
				ControlFactory::add_multiline_label($defs, '', $txt, 10);
				$return = false;
				$caption = "Остановить WEB GUI: $ip_address";
			}else if (isset($user_input->get_stop)){
				$pid = SmartConfig::rclone_rcd ();
				if ($pid == true)
					SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/rclone_kill.sh $pid");
				$action = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
				$this->do_exec_log();
				if ($this->execLogObj->status === false)
					return ActionFactory::show_title_dialog('Error!', $action, $exec_log->descr, 600, 1);
				return $action;
			}else{
				$this->counter = 0;
				$caption = 'Запустить WEB GUI';
				$add_params ['get_start'] = true;
				ControlFactory::add_close_dialog_and_apply_button(&$defs, $this, $add_params, 'web_gui', $caption, 450);
				$txt='WEB GUI (веб интерфейс rclone) используется для добавления и удаления облачных сервисов. Для доступа к WEB GUI необходимо указать:';
				ControlFactory::add_multiline_label($defs, '', $txt, 3);
				ControlFactory::add_vgap($defs, -15);
				if ($user_pass != 'admin')
					$user_pass = preg_replace("|.|", "*", $user_pass);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">Логин: </text><text color="15" size="normal">'.$user_login.'</text>
					<text color="10" size="normal"> Пароль: </text><text color="15" size="normal">'.$user_pass.'</text>'
				);
				ControlFactory::add_vgap($defs, -15);
				ControlFactory::add_close_dialog_and_apply_button(&$defs, $this, null, 'login_settings', 'Изменить логин и пароль', 450);
				ControlFactory::add_vgap($defs, -15);
				ControlFactory::add_smart_label($defs, "", 
					'<text size="small">*При необходимости можно изменить логин и пароль для доступа к WEB GUI</text>'
				);
				ControlFactory::add_vgap($defs, -35);
				ControlFactory::add_smart_label($defs, "", 
					'<text size="small">**Логин отключить нельзя</text>'
				);
				ControlFactory::add_close_dialog_button($defs, 'Закрыть', 450);
				$return = true;
				
			}
			return ActionFactory::show_dialog($caption, $defs, $return, 1250,$attrs);
		}
		if ($user_input->control_id === 'login_settings'){
			$defs = array();
			$login_settings = HD::get_items('login_settings');
			$user_login = isset($login_settings['user_login']) ? $login_settings['user_login'] : 'admin';
			$user_pass = isset($login_settings['user_pass']) ? $login_settings['user_pass'] : 'admin';
			if (isset($user_input->user_login)){
				$caption = '';
				if ($user_input->user_login == ''){
					if (isset($login_settings['user_login']))
						unset($login_settings['user_login']);
					$caption = "Логин задан по умолчанию\n";
				}else
					$login_settings['user_login'] = $user_input->user_login;
				if ($user_input->user_pass == ''){
					if (isset($login_settings['user_pass']))
						unset($login_settings['user_pass']);
					$caption .= 'Пароль задан по умолчанию';
				}else
					$login_settings['user_pass'] = $user_input->user_pass;
				HD::save_items('login_settings', $login_settings);
				$action = UserInputHandlerRegistry::create_action($this, 'web_gui');
				return ActionFactory::show_title_dialog('Логин и пароль сохранены', $action, $caption, 600, 1);
			}else{
				$ps = 1;
				if ($user_pass =='admin')
					$ps = 0;
				ControlFactory::add_text_field($defs, $this, null,
					'user_login',
					'',
					$user_login, 0, 0, 0, 1, 500, 0, false
				);
				ControlFactory::add_text_field($defs, $this, null,
					'user_pass',
					'',
					$user_pass, 0, $ps, 0, 1, 500, 0, false
				);
			}
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, null, 'login_settings', 'Применить', 450);
			return ActionFactory::show_dialog("Логин в WEB GUI", $defs, true, 0, $attrs);
		}
		if ($user_input->control_id === 'show_qr'){
			$img = DuneSystem::$properties['tmp_dir_path'].'/img.jpeg';
			$doc = HD::http_get_document('https://api.qrserver.com/v1/create-qr-code/?size=450x450&format=jpeg&data='.$user_input->qr_str);
			file_put_contents ($img, $doc);
			ControlFactory::add_smart_label($defs,"", '<icon width="400" height="400">'.$img.'</icon>');
			ControlFactory::add_vgap($defs, 400);
			return  ActionFactory::show_dialog("QR code",$defs,true,500,$attrs);
		}

		if ($user_input->control_id == 'whats_new'){
			$doc = shell_exec(DuneSystem::$properties['install_dir_path'] . "/bin/rclone version --config " . DuneSystem::$properties['data_dir_path'] .'/config');
			ControlFactory::add_multiline_label($defs, '', $doc, 3);
			$doc = HD::http_get_document('http://dune-club.info/plugins/update/'.DuneSystem::$properties['plugin_name'].'/info.txt');
			ControlFactory::add_multiline_label($defs, '', $doc, 5);
			ControlFactory::add_close_dialog_button($defs, 'ОК', 550);
			$action = UserInputHandlerRegistry::create_action($this, 'whats_new2');
			ControlFactory::add_custom_button($defs, $action, '_fg', null, 'Поддерживаемые сервисы', 550);
			return ActionFactory::show_dialog('Информация об изменениях', $defs, true, 1100,$attrs);
        }
		if ($user_input->control_id == 'whats_new2'){
			$doc = shell_exec(DuneSystem::$properties['install_dir_path'] . "/bin/rclone help backends");
			$arr = explode ("\n", preg_replace('|(\w+) {2,}|', '\\1 - ', $doc));
			$str = '';
			$i = 1;
			foreach($arr as $v)
				if (preg_match('| - |', $v)){
					$str .= "\n $i. " . trim($v);
					$i++;
				}
			ControlFactory::add_multiline_label($defs, '', $str, 14);
			ControlFactory::add_close_dialog_button($defs, 'ОК', 550);
			return ActionFactory::show_dialog('All rclone backends:', $defs, true, 1100,$attrs);
        }
		if ($user_input->control_id === 'main_icon')
            $plugin_cookies->main_icon = $user_input->main_icon;
		
        return ActionFactory::reset_controls(
            $this->do_get_control_defs($plugin_cookies));
    }
}

///////////////////////////////////////////////////////////////////////////
?>
