<?php
require_once 'lib/vod/vod.php';
require_once 'lib/abstract_preloaded_regular_screen.php';

class SmartListScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'list_screen';

	private $counter = 0;						# для web GUI
	private $title_counter = 0;					# счетчик обновлений окна
	private $all_counter = 0;					# всего в конфигурации
	private $all_names_counter = '';			# все имена в конфигурации через запятую
	private $mount_counter = 0; 				# всего смонтированных
	private $main_actions = null ;				# пока не знаю как это можно использовать.

	private $flag_Info_memory = false ;			# Специальные режим (вид для 'A' в нижнем баре (вывод инфо о свободной памяти и прочее)

	private $settings = array() ; 				# массив для настроек		
	private $name_file_settings = '' ;			# для "текущего" имени файла настроек

	private $change_name  = '' ;				# для изменения наименования облака
	private $change_team_drive = '' ;			# для изменения 'team_drive' облака (если есть)
	private $flag_log_err = false ;  	 		# флаг необходимисти вывода лога из 'sh' 

	private $View_num = 1; 						# номер набора иконок / номер вненшего вида окна

    public static function get_media_url_str($category = '', $first_arg = null){
		$arr['screen_id'] = self::ID;
        $arr['category'] = $category;
		if ($first_arg == true)
			$arr['first_arg'] = $first_arg;
		return MediaURL::encode($arr);	
    }

    ///////////////////////////////////////////////////////////////////////

    public function __construct(){

        parent::__construct(self::ID, $this->get_folder_views());
        
        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    protected function get_folder_views(){
        return $this->get_install_folder_views();
    }
    ///////////////////////////////////////////////////////////////////////



    public function get_action_map(MediaURL $media_url=null, &$plugin_cookies=null){


		$actions[GUI_EVENT_TIMER] = UserInputHandlerRegistry::create_action($this, 'timer');
		$actions[GUI_EVENT_KEY_ENTER] = UserInputHandlerRegistry::create_action($this, 'actions_app');
		$actions[GUI_EVENT_KEY_PLAY] = UserInputHandlerRegistry::create_action($this, 'actions_app');

		if ( empty($this->title_counter) ) {
			if ( ! file_exists('flashdata/plugins_data/rclone/cache_dir_path') ) {		# 
				file_put_contents ('/flashdata/plugins_data/rclone/cache_dir_path', '/flashdata/plugins_data/rclone');
			}
			if ( ! file_exists('flashdata/plugins_data/rclone/settings') ) {		# 
				$STR_SETUP  = '--vfs-cache-mode writes --read-only --vfs-cache-max-size 1G'; 
				$STR_SETUP .= ' --vfs-read-chunk-size-limit 1G --vfs-read-chunk-size 64M' ;
				$STR_SETUP .= ' --buffer-size 64M --vfs-cache-poll-interval 60s' ;
				file_put_contents ('/flashdata/plugins_data/rclone/settings', $STR_SETUP);
			}
		};
		$config_array = array();
		if ( is_file(DuneSystem::$properties['data_dir_path'] .'/config') ) $config_array = parse_ini_file(DuneSystem::$properties['data_dir_path'] .'/config', true, INI_SCANNER_RAW);
		if ( $config_array === false )
			$config_array = array();
		$this->all_counter = count($config_array);

		$add_action = UserInputHandlerRegistry::create_action($this, 'conf_setup');
		$add_action['caption'] = 'Конфигурация'; #.$this->title_counter;
		$actions[GUI_EVENT_KEY_A_RED] = $add_action;
		if ( $this->all_counter == 0 )
			return $actions;
		if ( $this->flag_Info_memory ) {
			$add_action = UserInputHandlerRegistry::create_action($this, 'flag_Info_memory');
			$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/mem_available.sh &";
			SmartConfig::do_cmd($cmd);
			$add_action['caption'] = ':'.number_format( file_get_contents('/flashdata/plugins_data/rclone/memory_info')/10 ,0).'%';
			$arr = explode(' ', file_get_contents('/flashdata/plugins_data/rclone/memory_info2'));
#			$add_action['caption'] .= ', L:'.number_format( ($arr[8]+$arr[10]+$arr[16])/($arr[6]+$arr[16])*100 ,0).'%';
			$add_action['caption'] .= ', L:'.number_format( ($arr[8]+$arr[10]+$arr[18])/($arr[6]+$arr[16])*100 ,0).'% ';

			$arr = explode(' ', shell_exec("echo $(cat /sys/class/thermal/thermal_zone*/temp) ."));
			for ($ii = 0; $ii < (count($arr)-1); $ii++) { 
				$add_action['caption'] .= ', T'.($ii+1).':'.number_format($arr[$ii]/1000,0).'°';
			}
			$actions[GUI_EVENT_KEY_A_RED] = $add_action;
		}else{
			if ( $this->all_counter > 1 ) {
				$add_action = UserInputHandlerRegistry::create_action($this, 'common_jobs');
				$add_action['caption'] = 'Общее';
				$actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
			}else{
				unlink("/flashdata/plugins_data/rclone/settings_".$this->all_names_counter);  # удаление инд.настроек, если одно подключение
			};
			if ( $this->all_counter > $this->mount_counter ) {
				$add_action = UserInputHandlerRegistry::create_action($this, 'setup_common');
				$add_action['caption'] = 'Настройки';
				$actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
			}
		}

		$add_action = UserInputHandlerRegistry::create_action($this, 'ver_info');
		$add_action['caption'] = 'Info';
		$actions[GUI_EVENT_KEY_D_BLUE] = $add_action;

		$actions[GUI_EVENT_KEY_POPUP_MENU] = UserInputHandlerRegistry::create_action($this, 'popup_menu');
		$actions[GUI_EVENT_KEY_CLEAR] = UserInputHandlerRegistry::create_action($this, 'remote_stop');

		$actions[GUI_EVENT_KEY_SELECT] = UserInputHandlerRegistry::create_action($this, 'flag_Info_memory');

		$actions[GUI_EVENT_KEY_INFO] = UserInputHandlerRegistry::create_action($this, '');

        return $actions;
    }

    public function get_handler_id()
	{ return self::ID; }

    private function get_update_action(&$user_input, &$plugin_cookies){
        $parent_media_url = MediaURL::decode($user_input->parent_media_url);
        $range = HD::create_regular_folder_range( $this->get_all_folder_items( $parent_media_url, $plugin_cookies));
        return ActionFactory::update_regular_folder( $range, true, 1);
    }
	public function do_exec_log(){
		if ( file_exists(DuneSystem::$properties['tmp_dir_path'].'/my_exec_log')){ 
			rename( DuneSystem::$properties['tmp_dir_path'].'/my_exec_log' , DuneSystem::$properties['tmp_dir_path'].'/exec_log' ) ;
		}
		$exec_log = ( is_file(DuneSystem::$properties['tmp_dir_path'].'/exec_log') ? file_get_contents(DuneSystem::$properties['tmp_dir_path'].'/exec_log') : '');
		$execLogObj = json_decode($exec_log);
		if (is_object($execLogObj))
			foreach ($execLogObj as $key => $value)
				hd_print("  $key => $value");
		else{
#			hd_print ("  str: " . $exec_log);
			$execLogObj = (object)array('descr'=> 1);
			$execLogObj->descr = $exec_log;
		}
		$this->execLogObj = $execLogObj;
    }
    public function handle_user_input(&$user_input, &$plugin_cookies){	
#		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);

		$action_timer = UserInputHandlerRegistry::create_action($this, 'timer' );

		$defs = array(); $add_params=array();

### Действия по таймеру
		if ( $user_input->control_id == 'timer' ) { 
### Автоматическое включение окна указиния для ввода конфигурации
			if ( empty($this->all_counter) ) { 
				$action = UserInputHandlerRegistry::create_action($this, 'conf_setup' ); 
				$action = ActionFactory::invalidate_folders(array($user_input->parent_media_url), $action); 
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Создать или загрузить', 0, $action);
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'' , 'Выход', 0, ActionFactory::close_and_run());
				return ActionFactory::show_dialog('Необходимо создать или загрузить файл конфигурации',$defs, false );
			}
### Проверка и вывод сообщений от скриптов
			$this->do_exec_log();
			if ( isset($this->execLogObj->status)) {
				if ($this->execLogObj->status === false || $this->flag_Info_memory ) { 
					$doc = $this->execLogObj->descr;
					$start_poz = strpos( $doc , ";");
					if ( $start_poz>0 ){
						$caption = substr($doc, 0 , $start_poz );	$start_poz++;
					}else{
						$caption = ''; $start_poz = 0;
					}
					$doc = substr($doc, $start_poz );	$doc = str_replace("^", "\r\n", $doc); 
					$action = ActionFactory::invalidate_folders(array($user_input->parent_media_url)); 
					return ActionFactory::show_title_dialog($caption, $action, $doc, 1800, 0);
				}
			}
### Автоматическое включение автомонтирования
			if ( file_exists(DuneSystem::$properties['data_dir_path'].'/flag_change_config') ) { 
				unlink(DuneSystem::$properties['data_dir_path'].'/flag_change_config');
				if ( is_file(DuneSystem::$properties['data_dir_path'].'/autostart_remote_name') ) unlink(DuneSystem::$properties['data_dir_path'].'/autostart_remote_name');	# удаления файла имен автомонтирования

				if ( $this->all_counter == 1 ) {	# если облако одно
					$media_url = MediaURL::decode($user_input->selected_media_url);
					$action = UserInputHandlerRegistry::create_action($this, 'm_autostsrt' ) ;
					$action = ActionFactory::invalidate_folders(array($user_input->parent_media_url), $action);	# ???
					return ActionFactory::show_title_dialog("Подключение: " . $media_url->caption, $action , 'Автоматически включен автозапуск,  отключить можно через <PopUp>', 1400, 0);
				}
			}
		}

		if ( $user_input->control_id == 'conf_setup' ) {
			$action1 = UserInputHandlerRegistry::create_action($this, 'import_conf');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Загрузить конфигурацию из файла', 800, $action1);

			$action2 = UserInputHandlerRegistry::create_action($this, 'web_gui');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'',
			(empty($this->all_counter) ? 'Создать' : 'Редактировать').' в Web GUI' , 800, $action2);

			if ( ! empty($this->all_counter) ) {
				$action3 = UserInputHandlerRegistry::create_action($this, 'exporn_conf');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Выгрузить конфигурацию в файл', 800, $action3);

				ControlFactory::add_vgap($defs, 30);
				$action4 = UserInputHandlerRegistry::create_action($this, 'test_MK');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', "Проверка папок 'МК'", 800, $action4);
			}
			return ActionFactory::show_dialog('Управление конфигурацией Rclone',$defs, true ,800);
		}
		if ($user_input->control_id == 'exporn_conf' ){
			$doc=file_get_contents('/flashdata/plugins_data/rclone/config');
			exec("rm /data/media/0/DuneHD/rclone.conf");
			file_put_contents('/data/media/0/DuneHD/rclone.conf', $doc);
			return ActionFactory::show_title_dialog("Конфигурация выгружена в файл <rclone.conf> во 'встроенную память'." , null , '' , 1300, 0);
		}
		if ($user_input->control_id == 'import_conf' ){
			$user_input->control_id = 'timer';
 			$media_url = MediaURL::encode (
				array(
					'screen_id'     => 'file_list',
					'save_file'		=> array(	
#					'parent' => self::ID,
					'action' => 'import_conf', 
					'extension' => 'conf',
					'ext_post_action' => ActionFactory::close_and_run(ActionFactory::open_folder('list_screen'))
					),
				)
			);
			return ActionFactory::open_folder($media_url, 'Импорт файла *.conf');
		}

		if ($user_input->control_id == 'open_files_info' ){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->launched)) {
				$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $media_url->caption . "'";
				$cmd .= ' "INFO_OPEN_FILES"';
			SmartConfig::do_cmd($cmd);
			}
		}
		if ( $user_input->control_id == 'script_sync' ) { 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_sync.sh 'Plugin' &";
			SmartConfig::do_cmd($cmd);
#			return ActionFactory::show_title_dialog("Фоновый подсчет размера подключения: " . $media_url->caption, null , 
#			'Результат отобразится автоматически по завершению подсчета.', 1300, 0);
		}
		if ( $user_input->control_id == 'cloud_size_info' ) { 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $media_url->caption . "'";
			$cmd .= ' "INFO_SIZE" &';
			SmartConfig::do_cmd($cmd);
			return ActionFactory::show_title_dialog("Фоновый подсчет размера подключения: " . $media_url->caption, null , 
			'Результат отобразится автоматически по завершению подсчета.', 1300, 0);
		}
#*************************
		if ( $user_input->control_id == 'test_MK' || $user_input->control_id == 'norm_MK' ) { 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$name_data_mk='/config/movie_index_config.xml';
			$flag_change_mk=false;
			$flag_err_mk=false;
			if ( file_exists($name_data_mk)) {
				$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $media_url->caption . "'";
				$cmd .= ' "EXT_PATH"';
				$current_ext_path=shell_exec($cmd);
				$iii=0;
				$arr_mk = explode('<folder', file_get_contents($name_data_mk));
				$doc=$arr_mk[0];
				$doc_change='';
				$txt_1= "* не заменять *";
				for ($ii = 1; $ii < count($arr_mk); $ii++) { 
					$arr_mk[$ii]='<folder'.$arr_mk[$ii];
					if ( (strpos( $arr_mk[$ii] , 'path="/RCLONE/') > 0) && (strpos( $arr_mk[$ii] , 'source_id="storage_name://') > 0) ){
						$iii++;
						if ( $current_ext_path == '' ) { 
							return ActionFactory::show_title_dialog("Ошибка: необходима папка RCLONE на одном из накопителей !", null , "" , 1300, 0);
						}
						$c1=strpos( $arr_mk[$ii] , '  caption="' );
						$c2=strpos( substr($arr_mk[$ii],$c1+11) , '"' );
						if ( $c1>0 && $c2>0 ){
							$c3="\r\n- папка '".substr($arr_mk[$ii], $c1+11, $c2 )."' :   ";
						}else{
							$c3="\r\n?";
						}
						if ( ! ( strpos( $arr_mk[$ii] , 'source_id="storage_name://'.$current_ext_path.'"' ) > 0 ) ){
							$flag_err_mk=true;
							$a1=strpos( $arr_mk[$ii] , 'source_id="storage_name://' );
							$a2=strpos( substr($arr_mk[$ii],$a1+26) , '"' );
							$a3=substr($arr_mk[$ii], $a1+26, $a2 );
							if ( $user_input->control_id == 'norm_MK' ){
								$arr_mk[$ii]=str_replace('source_id="storage_name://'.$a3.'"','source_id="storage_name://'.$current_ext_path.'"',$arr_mk[$ii]);
								$flag_change_mk=true;
							}
							$doc_change.= $c3."имя накопителя [".$a3."] ".
							($user_input->control_id == 'norm_MK' ? "замена на [".$current_ext_path."]" : "- нет такого накопителя");
						}
						$b1=strpos( $arr_mk[$ii] , 'path="/RCLONE/' );
						$b2_1=strpos( substr($arr_mk[$ii],$b1+14) , '/' );
						$b2_2=strpos( substr($arr_mk[$ii],$b1+14) , '"' );
	                    $b2=( ($b2_1<$b2_2) ? $b2_1 : $b2_2 ); 		
						$b3=substr($arr_mk[$ii], $b1+14, $b2 );
						if ( ! ( strpos( ' ,'.$this->all_names_counter.', ' , ','.$b3.',' ) > 0 ) ){
							$flag_err_mk=true;
							if ( $user_input->control_id == 'norm_MK' && $user_input->new_name != $txt_1){
								$arr_mk[$ii]=str_replace( 'path="/RCLONE/'.$b3.'/' , 'path="/RCLONE/'.$user_input->new_name.'/' ,$arr_mk[$ii]);
								$arr_mk[$ii]=str_replace( 'path="/RCLONE/'.$b3.'"' , 'path="/RCLONE/'.$user_input->new_name.'"' ,$arr_mk[$ii]);
								$flag_change_mk=true;
							}
							$doc_change.=$c3."имя подключения [".$b3."] ".
							( ($user_input->control_id == 'norm_MK' && $user_input->new_name != $txt_1 )  
							? "замена на [".$user_input->new_name."]" : "- нет такого подключения");
						}
					}
					$doc.=$arr_mk[$ii];	
				}
				if ( $flag_change_mk ) {
					file_put_contents($name_data_mk, $doc);
					$doc_change="Произведена корректировка:"."\r\n".$doc_change;
					$flag_err_mk=false;
				}else{
					$doc_change=($flag_err_mk ? "Есть ошибки:"."\r\n" : "Ошибок не обнаружено.").$doc_change;
				}
				$doc_change="Проверено папок: ".$iii.".  ".$doc_change;

				ControlFactory::add_multiline_label($defs, '' ,$doc_change."\r\n\r\n" , 10);

				if ( $flag_err_mk ) {
					if ( (strpos( $doc_change , "- нет такого подключения") > 0) ){
						ControlFactory::add_multiline_label($defs, '' , "'несуществующие' подключения будут заменены на:" , 1);
						foreach (explode(',', $this->all_names_counter) as $elem) {
							$arr_name[$elem] = $elem;
						}
						$arr_name[$txt_1] = $txt_1;
# unset($arr_name['MAIL']); удаление элемента массива
						ControlFactory::add_combobox($defs, $this, null, 'new_name', '', $media_url->caption, $arr_name, 0 , false, false );
					}
					ControlFactory::add_vgap($defs, 30);
					$action = UserInputHandlerRegistry::create_action($this, 'norm_MK');
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Исправить ошибки', 500, $action);
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Отказаться', 500, null );
				}else{
					if ( strpos( $doc_change , "Произведена корректировка:") === false ) {
						ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'ОК', 300, null );
					}else{
						$action = UserInputHandlerRegistry::create_action($this, 'reboot after_norm_MK');
						ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Будет выполнена перезагрузка', 500, $action);
					}
				}

				return ActionFactory::show_dialog("Результат проверки папок 'МК'   ( проверяются папки с доступом через каталог RCLONE )", $defs, false, 1800);
			}else{
				return ActionFactory::show_title_dialog("Нет файла 'МК': ".$name_data_mk, null , "" , 1000, 0);
			}
		}
		if ($user_input->control_id == 'reboot after_norm_MK'){ 
			SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/restart.sh &");
			return ActionFactory::show_dialog("Ожидание перезагрузки...", $defs, false);
		}

# ============ Изменение Имени и 'team_drive'
		if ($user_input->control_id == 'name_change' || $user_input->control_id == 'name_change_repeat'){ 
			$media_url = MediaURL::decode($user_input->selected_media_url);

			if ($user_input->control_id == 'name_change'){ 
				$this->change_name  = $media_url->caption ;				# 
				$this->change_team_drive = $media_url->team_drive ;			# 
			}

			ControlFactory::add_text_field($defs, $this, null,
				'change_name',
#				'Подключение',
				'Наименование',
					$this->change_name, 0, 0, 0, 1, 900, 0, false
			);
			ControlFactory::add_smart_label($defs,"", '<gap width="0"/><text dy="0" size="small">'.
			"допустимые символы:  0-9   A-Z   a-z   _    -    одиночный пробел".
			'</text>');

			if ( !empty($media_url->team_drive) ) { 
				ControlFactory::add_text_field($defs, $this, null,
					'change_team_drive',
					"'team_drive' =",
						$this->change_team_drive, 0, 0, 0, 1, 900, 0, false
				);
			ControlFactory::add_smart_label($defs,"", '<gap width="0"/><text dy="0" size="small">'.
			"некорректное значение приведет к потере доступа к облаку !".
			'</text>');
			}

			ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'name_change_save', 'Сохранить' ,300);

			return ActionFactory::show_dialog( "Изменить: ".$media_url->caption , $defs, true , 1300); 
		}


		if ($user_input->control_id == 'name_change_save'){ 
			$media_url = MediaURL::decode($user_input->selected_media_url);

			$doc_err='';
			$user_input->change_name=trim($user_input->change_name);
			$user_input->change_team_drive=trim($user_input->change_team_drive);

			if ( empty($user_input->change_name) ) { 
				$doc_err.="Наименование подключения не может быть пустым\n\r";
			}
			if ( empty($doc_err) && (strpos( $user_input->change_name , "  ") > 0) ){
				$doc_err.="Наименование подключения не может содержать двойного пробела\n\r";
			}
			if ( empty($doc_err) ){
				for ($ii = 0; $ii < strlen($user_input->change_name); $ii++) { 
					$ii_change_name=substr($user_input->change_name, $ii, 1);
					if ( !( $ii_change_name =="_" || $ii_change_name =="-" || $ii_change_name ==" " || 
					(ord($ii_change_name) >= ord('0') && ord($ii_change_name) <= ord('9')) ||
					(ord($ii_change_name) >= ord('A') && ord($ii_change_name) <= ord('Z')) ||
					(ord($ii_change_name) >= ord('a') && ord($ii_change_name) <= ord('z')) ) ) { 
						$doc_err.="Наименование подключения включает недопустимый символ\n\r";
						break;	
					}
				}
			}
			if ( empty($doc_err) ){
				if ( strpos( strtoupper(str_replace(",".$media_url->caption."," , "," , " ,".$this->all_names_counter.", " )), ','.strtoupper($user_input->change_name).',') > 0 ){
					$doc_err.="Такое наименование подключения уже существует\n\r";
				}
			}

			if ( !empty($media_url->team_drive) ) { 
				if ( empty($user_input->change_team_drive) ) { 
					$doc_err.="'team_drive' не может быть пустым\n\r";
				}
			}
			if ( !empty($doc_err) ) { 
				$this->change_name  = $user_input->change_name ;				
				$this->change_team_drive =  $user_input->change_team_drive;			
				ControlFactory::add_multiline_label($defs, '', $doc_err."\n\r", 10);
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'name_change_repeat', 'Повторить' ,300);
				return ActionFactory::show_dialog( "Ошибка ввода" , $defs, true , 1400); 
			}

			$arr = explode('[', file_get_contents('/flashdata/plugins_data/rclone/config'));
			$nomer=0;
			for ($ii = 1; $ii < count($arr); $ii++) { 
				$arr[$ii]='['.$arr[$ii];
				if ( strpos( ' '.$arr[$ii].' ' , '['.$media_url->caption.']') > 0 ){
					$nomer=$ii;
				}
			}
			if ( empty($nomer) ){ 
				return ActionFactory::show_title_dialog("Внутренняя ошибка 0", null , "" , 700, 0);
			}
			$arr_n=$arr[$nomer];
			$arr_n=str_replace(" =","=",$arr_n);
			$arr_n=str_replace("= ","=",$arr_n);

			$arr_n=str_replace("[".$media_url->caption."]","[".$user_input->change_name."]",$arr_n);
			if ( !empty($media_url->team_drive) ) { 
				$arr_n=str_replace("team_drive=".$media_url->team_drive,"team_drive=".$user_input->change_team_drive,$arr_n);
			}
			$arr_n=str_replace("="," = ",$arr_n);
			$arr[$nomer]=$arr_n;
			exec("rm /flashdata/plugins_data/rclone/config");
			file_put_contents('/flashdata/plugins_data/rclone/config', implode($arr));

			if ( file_exists('/flashdata/plugins_data/rclone/autostart_remote_name') ){
				$autostart_in = ",".file_get_contents ('/flashdata/plugins_data/rclone/autostart_remote_name').",";
				$autostart_in = str_replace(",".$media_url->caption.",",",".$user_input->change_name.",",$autostart_in);
				$autostart_in = trim($autostart_in,',');
				exec("rm /flashdata/plugins_data/rclone/autostart_remote_name");
				file_put_contents ('/flashdata/plugins_data/rclone/autostart_remote_name', $autostart_in);
			}

			if ( file_exists("/flashdata/plugins_data/rclone/settings_".$media_url->caption) ){
				exec("mv /flashdata/plugins_data/rclone/settings_".$media_url->caption." /flashdata/plugins_data/rclone/settings_".$user_input->change_name);
			}

		}


################################################################
		if ($user_input->control_id == 'setup_common'){ 
			$this->name_file_settings = 'settings' ;
			return UserInputHandlerRegistry::create_action($this, 'new_setup');	
		}
		if ($user_input->control_id == 'setup_private'){ 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if ( ! file_exists('flashdata/plugins_data/rclone/'.'settings_'.$media_url->caption) ){ 
#				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, '', 'Отказаться' ,300);
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'do_setup_private',
				'Создать на основе общих настроек и перейти к редактированию' ,1300);
				return ActionFactory::show_dialog("Создание индивидуальных настроек для: ".$media_url->caption, $defs, true , 1300);   
			}else{
				return UserInputHandlerRegistry::create_action($this, 'do_setup_private');	
			}
		}
		if ($user_input->control_id == 'do_setup_private'){ 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$this->name_file_settings = 'settings_'.$media_url->caption ;
			$action = UserInputHandlerRegistry::create_action($this, 'new_setup') ;
			if ( ! file_exists('flashdata/plugins_data/rclone/'.$this->name_file_settings )) {
				$doc = HD::get_item('settings');
				HD::save_item( $this->name_file_settings , $doc);
			}
			return $action ;	
		}
		if ( $user_input->control_id == 'new_setup'){ 
			if ( $this->name_file_settings == 'settings' ){

				if (file_exists('/persistfs'))
					$cache_ops[DuneSystem::$properties['data_dir_path']] = 'Системный накопитель' . ' (' . HD::get_storage_size('/persistfs') .')';
				else if (file_exists('/flashdata'))
					$cache_ops[DuneSystem::$properties['data_dir_path']] = 'FLASHdata' . ' (' . HD::get_storage_size('/flashdata') .')';
				foreach (glob('/tmp/mnt/storage/*') as $file)
					if (is_dir($file))
						$cache_ops[$file] = substr($file, 17, 39-strlen(HD::get_storage_size($file))) . ' (' . HD::get_storage_size($file) .')';

				$cache_dir = (HD::get_item('cache_dir_path') !='') ? HD::get_item('cache_dir_path') : DuneSystem::$properties['data_dir_path'];
				if ($cache_dir != DuneSystem::$properties['data_dir_path'])
					$cache_dir = str_replace('/' .DuneSystem::$properties['plugin_name'], '', $cache_dir);

				ControlFactory::add_combobox($defs, $this, null,
					'cache_dir', 'Расположение кэш',
					$cache_dir, $cache_ops, 930, false, false
				);
				ControlFactory::add_smart_label($defs,"", '<gap width="950"/><text dy="-65" size="small">желательно не FLASHdata</text>');
				ControlFactory::add_vgap($defs, -70);

				$StopList_RC = HD::get_item('no_ports');
				ControlFactory::add_text_field($defs, $this, null,
					'StopList_RC',
					'Команды кэширования',
						$StopList_RC, 0, 0, 0, 1, 1100, 0, false
				);
				ControlFactory::add_smart_label($defs,"",
				'<gap width="1120"/><text dy="-65" size="small">опционально</text>');

				ControlFactory::add_smart_label($defs,"",
				"<gap width='0'/><text dy='-75' size='small'>варианты:  '-сache',  'ЧЧ:ММ'-метки времени автокэширования,  'NNNN'-исключаемые порты</text>");

				ControlFactory::add_vgap($defs, -60);
			}

		$ii=0;
			$this->settings[$ii]['name'] = 'read-only';
			$this->settings[$ii]['vars'] = 'ON,off';
			$this->settings[$ii]['dflt'] = 'ON';
			$this->settings[$ii]['mesg'] = 'режим "только чтение", запись, удаление и изменение будут запрещены';

		$ii++;
			$this->settings[$ii]['name'] = 'vfs-cache-mode';
			$this->settings[$ii]['vars'] = 'full,writes,minimal,off';
			$this->settings[$ii]['dflt'] = 'writes';
			$this->settings[$ii]['mesg'] = 'режим работы кэш';

		$ii++;
			$this->settings[$ii]['name'] = 'buffer-size';
			$this->settings[$ii]['vars'] = '8M,16M,32M,64M,128M,256M,512M';
			$this->settings[$ii]['dflt'] = '64M';
			$this->settings[$ii]['mesg'] = 'размер буфера чтения/записи';

		$ii++;
			$this->settings[$ii]['name'] = 'vfs-cache-max-size';
			$this->settings[$ii]['vars'] = '16M,64M,256M,1G,4G,16G,64G,128G,256G';
			$this->settings[$ii]['dflt'] = '1G';
			$this->settings[$ii]['mesg'] = 'максимальный размер кэш';

		$ii++;
			$this->settings[$ii]['name'] = 'vfs-read-chunk-size';
			$this->settings[$ii]['vars'] = '0,8M,16M,32M,64M,128M,256M,512M';
			$this->settings[$ii]['dflt'] = '64M';
			$this->settings[$ii]['mesg'] = 'начальный размер блоков чтения файлов (0-без фрагментации)';

		$ii++;
			$this->settings[$ii]['name'] = 'vfs-read-chunk-size-limit';
			$this->settings[$ii]['vars'] = '0,16M,64M,256M,1G,4G,16G,64G,128G,256G';
			$this->settings[$ii]['dflt'] = '1G';
			$this->settings[$ii]['mesg'] = 'макс. размер блоков для каждого открытого файла (0-без ограничения)';

		$ii++;
			$this->settings[$ii]['name'] = 'vfs-cache-poll-interval';
			$this->settings[$ii]['vars'] = '1s,5s,15s,60s';
			$this->settings[$ii]['dflt'] = '60s';
			$this->settings[$ii]['mesg'] = 'интервал опроса кэш на наличие устаревших объектов';

#			$settings_file = file_get_contents ('/flashdata/plugins_data/rclone/settings');
			$settings_file = HD::get_item($this->name_file_settings);
			$settings_file = '- '.$settings_file.' --';

			for ($ii = 0; $ii < count($this->settings); $ii++) { 
				if ( $this->settings[$ii]['name'] == 'read-only' ){
					if ( strpos( $settings_file , '--read-only' ) > 0 ) {
						$input_set = 'ON';
					}else{
						$input_set = 'off';
					};
				}else{
					$pos1 = strpos( $settings_file , '--'.$this->settings[$ii]['name'].' ' ) ;
					if ( $pos1 > 0 ) {
						$pos2 = strpos( $settings_file , '--', ($pos1+2) ) ;
						$input_set = substr( $settings_file, $pos1 + strlen($this->settings[$ii]['name'])+3 ,
									( $pos2 - $pos1 - strlen($this->settings[$ii]['name']) -4 ) );
#$this->settings[$ii]['mesg']=$input_set;
					}else{
						return ActionFactory::show_title_dialog('В файле настроек <' . $this->name_file_settings . '>' ,
						null , 'Нет данных для параметра: '.$this->settings[$ii]['name'], 1300, 0);
						$input_set = $this->settings[$ii]['dflt'] ;
					};
				};

				foreach (explode(',', $this->settings[$ii]['vars']) as $elem) {
					$this->settings[$ii]['arrN'][$elem] = $elem;
				}
				ControlFactory::add_combobox($defs, $this, null,
					$this->settings[$ii]['name'], $this->settings[$ii]['name'],
					$input_set, $this->settings[$ii]['arrN'], 220, false, false
				);
				ControlFactory::add_smart_label($defs,"", '<gap width="250"/><text dy="-60" size="small">- '.$this->settings[$ii]['mesg'].'</text>');
				ControlFactory::add_vgap($defs, -70);  # 80 - вплотную
			}
			ControlFactory::add_vgap($defs, 30);

#			ControlFactory::add_multiline_label($defs, '', '', 1);
			if ( $this->name_file_settings == 'settings' ){
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'save_setup', 'Сохранить' ,350);
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'question_default_setup', 'Восстановить базовые настройки' ,675);
				return ActionFactory::show_dialog( ( ( $this->all_counter > 1 ) ? "Общие настройки" : "Настройки" ).
				" монтирования Rclone:   !!! изменяйте только если понимаете что делаете !!!", $defs, true , 1800);   # вопрос перед ссохранением
			}else{
				$media_url = MediaURL::decode($user_input->selected_media_url);
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'save_setup', 'Сохранить' ,350);
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'del_setup',
				'Отказаться от индивидуальных настроек и продолжить использовать общие настройки' ,1700);
				return ActionFactory::show_dialog("Индивидуальные настройки монтирования Rclone для: ".$media_url->caption, $defs, true , 1800);   # вопрос перед ссохранением
			}
		}

		if ( $user_input->control_id == 'del_setup'){
			unlink("/flashdata/plugins_data/rclone/".$this->name_file_settings);
		}
		if ( $user_input->control_id == 'save_setup'){
			if ( $this->name_file_settings == 'settings' ){
				HD::save_item('cache_dir_path', $user_input->cache_dir);
				HD::save_item('no_ports', $user_input->StopList_RC);
			}
			$doc='';
			for ($ii = 0; $ii < count($this->settings); $ii++) { # 8
				$ss=$this->settings[$ii]['name'];
				if ($ss == 'read-only'){
					if ($user_input->$ss == 'ON'){
						$doc .= ' --read-only';
					}
				}else{
					$doc .= ' --'.$this->settings[$ii]['name'].' '.$user_input->$ss;
				}
			}
#			file_put_contents ('/flashdata/plugins_data/rclone/settings', $doc);
			HD::save_item( $this->name_file_settings , $doc);
#			return ActionFactory::show_title_dialog('Сохранено в <' . $this->name_file_settings . '>' , null , '', 800, 0);

		}
		if ($user_input->control_id == 'question_default_setup'){  
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, '', 'Отказаться' ,300);
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'default_setup', 'Подтвердить' ,300);
			return ActionFactory::show_dialog( ( ( $this->all_counter > 1 ) ? "Общие настройки" : "Настройки" ).
			" будут сброшены на базовые", $defs, true , 900);   # вопрос перед ссохранением
		}
		if ($user_input->control_id == 'default_setup'){
			exec("rm /flashdata/plugins_data/rclone/cache_dir_path");
			exec("rm /flashdata/plugins_data/rclone/no_ports");
			exec("rm /flashdata/plugins_data/rclone/settings");
			$this->title_counter = 0;
			return ActionFactory::show_title_dialog("Восстановлены базовые настройки", null , '', 800, 0);
		}
#################################################################
		if ($user_input->control_id == 'all_remote_start'){
			SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $this->all_names_counter . "' &");
			sleep(2);			# зрительный эффект монтирования
		}
		if ($user_input->control_id == 'ver_info'){
			$doc  = "- восстановлен доступ через папки из 'встроенной памяти' или иконку плагина\r\n";
			$doc .= "( через иконку:  <ENTER> - подключения,  <PLAY> - вход в последнее запущенное )\r\n";
			$doc .= "( внутри плагина:  <ENTER> или <PLAY> - запуск подключения / вход в запущенное );\r\n";
			$doc .= "- возможность одновременной работы множества подключений;\r\n";
			$doc .= "- разрешено использование в именах подключений символа 'минус' ( - );\r\n";			
			$doc .= "- контроль стабильности интернета при запуске кэширования;\r\n";			
			$doc .= "- возможность исключать произвольные порты из диапазона работы RC Rclone;\r\n";			
			$doc .= "- возможность создавать индивидуальные настройки для любого подключения;\r\n";			
			$doc .= "- возможность создавать копии монтирований на одном из внешних накопителей\r\n";			
			$doc .= "( нужно в 'корне' накопителя создать заглавными буквами папку с именем RCLONE );\r\n";
			$doc .= "- устранен конфликт между кэшированием в плагине и работой VPN Psiphon;\r\n";
			$doc .= "- проверка папок 'МК' на корректность доступа и автоматическая корректировка;\r\n";
			$doc .= "- возможность изменять имя подключения и код 'team_drive'.\r\n";
			$doc .= "- возможность отключения первичного кэширования подключений\r\n";
			$doc .= "( нужно в Настройках в поле 'Команды кэширования' внести текст '-cache' ).\r\n";
			$doc .= "- возможность указать моменты времени для автокэширования подключений\r\n";

#			$doc=var_export(DuneSystem::$properties , true );

			ControlFactory::add_vgap($defs, -10);
			ControlFactory::add_multiline_label($defs, '', $doc, 100);

			ControlFactory::add_vgap($defs, 0);
			$action = UserInputHandlerRegistry::create_action($this, 'lisr_type_rclone');
			ControlFactory::add_custom_button($defs, $action, '_fg', null, 'Доступные сервисы', 400);
			$doc  = 'Plugin v.'.HD::plugin_version();
			$doc .= " / ";
			$doc .= shell_exec(DuneSystem::$properties['install_dir_path'] . "/bin/rclone version 2>/dev/null | grep -e rclone -e os/type -e os/arch");
			$doc  = str_replace( "\r", ' ', $doc); 
			$doc  = str_replace( "\n", ' ', $doc); 
			ControlFactory::add_vgap($defs, 0);
			ControlFactory::add_smart_label($defs,"", '<gap width="380"/><text dy="-65" size="small">'.$doc.'</text>');
			ControlFactory::add_vgap($defs, -70);
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'change_design', 'Смена оформления', 400);
			ControlFactory::add_vgap($defs, -20);
			ControlFactory::add_smart_label($defs,"", '<gap width="380"/><text dy="-60" size="small">'.'Особая благодарность: TrippyCat, Alex1963, Avenso, Braverheart74, Brigadir, Xemu'.'</text>');
			ControlFactory::add_vgap($defs, -30);
			ControlFactory::add_smart_label($defs,"", '<gap width="725"/><text dy="-60" size="small">'."за 'основу', идеи, подсказки, дизайн и вдохновение !".'</text>');
			ControlFactory::add_vgap($defs, -70);

			return ActionFactory::show_dialog('Info', $defs, true, 1600);
        }
		if ($user_input->control_id == 'lisr_type_rclone'){
			$doc = shell_exec(DuneSystem::$properties['install_dir_path'] . "/bin/rclone help backends");
			$arr = explode ("\n", preg_replace('|(\w+) {2,}|', '\\1 - ', $doc));
			$str = '';
			$i = 1;
			foreach($arr as $v)
				if (preg_match('| - |', $v)){
					$str .= "\n $i. " . trim($v);
					$i++;
				}
			ControlFactory::add_multiline_label($defs, '', $str, 17);
#			ControlFactory::add_close_dialog_button($defs, 'ОК', 550);
			return ActionFactory::show_dialog('All rclone backends:', $defs, true, 1100);
        }

		if ($user_input->control_id == 'change_design') {
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'change_icons', 'Следующий по порядку типовой вариант', 1000);
			ControlFactory::add_vgap($defs, 30);
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'import_bg', 'Загрузить фоновый рисунок (background)', 1000);
			if ( file_exists(DuneSystem::$properties['install_dir_path'] .'/icons/bg_rclone.jpg') )	
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'del_bg', 'Убрать фоновый рисунок (background)', 1000);
			return ActionFactory::show_dialog('Смена оформления', $defs, true, 1000);
		}

		if ($user_input->control_id == 'change_icons'){
			if ( file_exists('/flashdata/plugins/rclone/icons/Number.txt') ) {		
				$Number_now = file_get_contents('/flashdata/plugins/rclone/icons/Number.txt'); 
				$Number_now++;				
				if ( ! file_exists('/flashdata/plugins/rclone/icons_'.$Number_now.'.tar') ){
					$Number_now = 1 ;				
				}
				if ( file_exists('/flashdata/plugins/rclone/icons_'.$Number_now.'.tar') ){
					SmartConfig::do_cmd("cd /flashdata/plugins/rclone ; tar -xf icons_".$Number_now.".tar");
					SmartConfig::do_cmd("chmod -R 777 /flashdata/plugins/rclone/icons");
					return ActionFactory::change_settings(null, null, true);
				}
			}
        }
		if ($user_input->control_id == 'import_bg' ){
 			$media_url = MediaURL::encode (
				array(
					'screen_id'     => 'file_list',
					'save_file'		=> array(	
#					'parent' => self::ID,
					'action' => 'import_bg', 
					'extension' => 'jpg',
					'ext_post_action' => ActionFactory::change_settings(null, null, true)
					),
				)
			);
			return ActionFactory::open_folder($media_url, 'Импорт файла *.jpg');
		}
		if ($user_input->control_id == 'del_bg'){
			unlink(DuneSystem::$properties['install_dir_path'] .'/icons/bg_rclone.jpg');
			return ActionFactory::change_settings(null, null, true);
        }


		if ($user_input->control_id == 'popup_menu'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$autostart_in = ( is_file('/flashdata/plugins_data/rclone/autostart_remote_name') ? file_get_contents ('/flashdata/plugins_data/rclone/autostart_remote_name') : '');
			if ( strpos( " ,".$autostart_in.", " , ",".trim($media_url->caption).",") ){    # Новый вариант анализа метки автомонтирования
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Отключить автозапуск',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'm_autostsrt')
				);
			}else{
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Включить автозапуск',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'm_autostsrt' )
				);
			}

			if (isset($media_url->launched)){
				$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Остановить   <CLEAR>',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'do_remote_stop')
				);
				if ( SmartListScreen::get_status_mount( $media_url->caption ) == 1) {
					$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
					$menu_items[] = array(
						GuiMenuItemDef::caption => 'Обновление кэш',
						GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'do_cache')
					);
				};
				if ( $this->flag_Info_memory ) {
					$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
					$menu_items[] = array(
						GuiMenuItemDef::caption => "* kill rclone ",
						GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'do_remote_kill')
					);
					$menu_items[] = array(
						GuiMenuItemDef::caption => '* Список файловых процессов',
						GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'open_files_info')
					);
				};
			};
			if ( ! isset($media_url->size_info)){
				$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Подсчитать размер',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'cloud_size_info')
				);
			};
			if ( ($this->all_counter > 1) && ! isset($media_url->launched) ) {
				$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Индивидуальные настройки',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'setup_private')
				);
				$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Переместить',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'popup_menu_move')
				);
			};
			if ( ! isset($media_url->launched)){
				$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Изменить Имя'.( ! empty($media_url->team_drive) ? " и 'team_drive'" : ''),
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'name_change')
				);
			};

			$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
			$menu_items[] = array(
				GuiMenuItemDef::caption => 'Цветные кнопки',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'popup_menu_color'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/top_section_setup.aai'
			);
			$count_webdav = exec("ps w | grep 'rclone serve webdav' | grep -v grep | wc -l");
			if ( !empty($count_webdav) ) {
				$menu_items [] =  array( GuiMenuItemDef::is_separator => true );  # полоска в меню
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Серверов WebDAV: '.$count_webdav,
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'WebDAV'),
				);
			}

			return ActionFactory::show_popup_menu($menu_items);
		}

		if ($user_input->control_id == 'WebDAV'){
			return ActionFactory::show_title_dialog('WebDAV', null,
			shell_exec("ps w | grep 'rclone serve webdav' | grep -v grep"), 1700);
		}

		if ($user_input->control_id == 'popup_menu_color'){
			$actions=SmartListScreen::get_action_map();
			if (isset($actions[GUI_EVENT_KEY_A_RED]))
				$menu_items[] = array(
					GuiMenuItemDef::action => $actions[GUI_EVENT_KEY_A_RED],
					GuiMenuItemDef::caption => $actions[GUI_EVENT_KEY_A_RED]['caption'],
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/controls_button_red.aai'
				);
			if (isset($actions[GUI_EVENT_KEY_B_GREEN]))
				$menu_items[] = array(
					GuiMenuItemDef::action => $actions[GUI_EVENT_KEY_B_GREEN],
					GuiMenuItemDef::caption => $actions[GUI_EVENT_KEY_B_GREEN]['caption'],
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/controls_button_green.aai'
				);
			if (isset($actions[GUI_EVENT_KEY_C_YELLOW]))
				$menu_items[] = array(
					GuiMenuItemDef::action => $actions[GUI_EVENT_KEY_C_YELLOW],
					GuiMenuItemDef::caption => $actions[GUI_EVENT_KEY_C_YELLOW]['caption'],
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/controls_button_yellow.aai'
				);
			if (isset($actions[GUI_EVENT_KEY_D_BLUE]))
				$menu_items[] = array(
					GuiMenuItemDef::action => $actions[GUI_EVENT_KEY_D_BLUE],
					GuiMenuItemDef::caption => $actions[GUI_EVENT_KEY_D_BLUE]['caption'],
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/controls_button_blue.aai'
				);
			if (isset($menu_items))
				return ActionFactory::show_popup_menu($menu_items);
		}

		if ($user_input->control_id == 'popup_menu_move'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if ( SmartListScreen::move_up_or_down($media_url->caption,true,'?') ) {
				$menu_items[] = array(
						GuiMenuItemDef::caption => 'выше',
						GuiMenuItemDef::icon_url => 'plugin_file://icons/up.png',
						GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'move_up')
					);
			}
			if ( SmartListScreen::move_up_or_down($media_url->caption,false,'?') ) {
					$menu_items[] = array(
						GuiMenuItemDef::caption => 'ниже',
						GuiMenuItemDef::icon_url => 'plugin_file://icons/lo.png',
						GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'move_down')
					);
			}
			return ActionFactory::show_popup_menu($menu_items);
		}
		if ($user_input->control_id == 'move_up'){ 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			SmartListScreen::move_up_or_down($media_url->caption,true);
		}
		if ($user_input->control_id == 'move_down'){ 
			$media_url = MediaURL::decode($user_input->selected_media_url);
			SmartListScreen::move_up_or_down($media_url->caption,false);
		}



		if ($user_input->control_id == 'm_autostsrt'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$autostart_in = file_get_contents ('/flashdata/plugins_data/rclone/autostart_remote_name');
			$caption = $media_url->caption;
			if ( strpos( " ,".$autostart_in.", " , ",".trim($media_url->caption).",") ){    # Новый вариант анализа метки автомонтирования
				$autostart_in = ',' . $autostart_in . ','  ;
				$autostart_in = str_replace(','.$caption.',' , ",",$autostart_in);
				$autostart_in = trim($autostart_in,',');
				$maess = "Отключен";			
			}
			else{
				$autostart_in .= ',' . $caption ;
				$autostart_in = trim($autostart_in,',');
				$maess = "Включен";			
			}
			if ( $autostart_in != "") {
				file_put_contents ('/flashdata/plugins_data/rclone/autostart_remote_name', $autostart_in);
			}else{
				exec("rm /flashdata/plugins_data/rclone/autostart_remote_name");
			}
		}
		if ($user_input->control_id == 'remote_stop'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->launched)) {
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'do_remote_stop', 'Остановить' ,850);
				return ActionFactory::show_dialog("Подключение: " . $media_url->caption, $defs, true , 900);   # вопрос перед остановить
			}
		}
		if ($user_input->control_id == 'do_remote_stop'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $media_url->caption . "'";
			$cmd .= ' "UMOUNT" &';
			SmartConfig::do_cmd($cmd);
			sleep(2);			# зрительный эффект размонтирования
		}
		if ($user_input->control_id == 'do_remote_kill'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $media_url->caption . "'";
			$cmd .= ' "KILL"';
			SmartConfig::do_cmd($cmd);
#			sleep(2);			# зрительный эффект размонтирования
		}
		if ($user_input->control_id == 'all_remote_stop'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $this->all_names_counter . "'";
			$cmd .= ' "UMOUNT" &' ;
			SmartConfig::do_cmd($cmd);
			sleep(2);			# зрительный эффект размонтирования
		}
		if ( $user_input->control_id == 'actions_app' ){
			if (!isset($user_input->selected_media_url)) 
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->launched)){
				return SmartListScreen::get_open_mount( $media_url->caption ) ; # запуск браузера подключения (с проверкой кэширования)
			}else{
				$cmd = DuneSystem::$properties['install_dir_path'] . "/bin/rclone_mount.sh '" . $media_url->caption . "'";
				$cmd .= " &";		# выход без ожидания
				SmartConfig::do_cmd($cmd);
				sleep(2);			# зрительный эффект монтирования
			}
		}
		if ($user_input->control_id == 'common_jobs'){
			if ( $this->mount_counter > 0 ) {
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'all_cache', 'Обновление кэш' ,550);
			};
			if ( $this->all_counter > $this->mount_counter ) {
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'all_remote_start', 'Все запустить' ,550);
			};
			if ( $this->mount_counter > 0 ) {
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'all_remote_stop', 'Все остановить' ,550);
			};
			if ( file_exists('/data/media/0/DuneHD/rclone_copy_jobs.txt') || file_exists('/sdcard/DuneHD/rclone_copy_jobs.txt') ) {		
				ControlFactory::add_vgap($defs, -35);
				ControlFactory::add_multiline_label($defs, "", '__________________________' );
				ControlFactory::add_close_dialog_and_apply_button($defs, $this, $add_params, 'script_sync', 'Меню скрипта копирования' ,550);
			};
			return ActionFactory::show_dialog("Общие действия" , $defs, true , 550);  
		}
		if ($user_input->control_id == 'all_cache'){
			SmartConfig::do_cmd("ps w | grep 'rclone mount' | grep '127.0.0.1' > /flashdata/plugins_data/rclone/rc_port_cache_jobs &");
			sleep(1);	# зрительный эффект начала кэширования
		}
		if ($user_input->control_id == 'do_cache'){
			$media_url = MediaURL::decode($user_input->selected_media_url);
			SmartConfig::do_cmd("ps w | grep 'rclone mount ".$media_url->caption."': | grep '127.0.0.1' > /flashdata/plugins_data/rclone/rc_port_cache_jobs &");
			sleep(1);	# зрительный эффект начала кэширования
		}

		if ($user_input->control_id == 'web_gui'){
			$ip_address = 'http://' .HD::get_ip_address().':5572';
			$login_settings = HD::get_items('login_settings');
			$user_login = isset($login_settings['user_login']) ? $login_settings['user_login'] : 'admin';
			$user_pass = isset($login_settings['user_pass']) ? $login_settings['user_pass'] : 'admin';
			if ((SmartConfig::rclone_rcd () == true)&&(!isset($user_input->get_stop)))
				$user_input->get_started = 1;
			if (isset($user_input->get_start)){
				if ($this->counter == 0)
					SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/rclone_rcdstart.sh ". HD::get_ip_address() ." $user_login $user_pass");			
				$this->counter++;
				$this->do_exec_log();
				if ((isset($this->execLogObj->status))&&($this->execLogObj->status === false)){
					$action = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
					return ActionFactory::show_title_dialog('Error!', $action, $this->execLogObj->descr, 600, 1);
				}
				ControlFactory::add_label($defs, '', "%ext%<key_local>sec__1<p>".HD::sec_format_duration($this->counter)."</p></key_local>");
				if (HD::isDomainAvailible($ip_address, 1) == true){
					$add_params ['get_started'] = true;
				}else if ($this->counter > 25){
					$action = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
					return ActionFactory::show_title_dialog('Error!', $action, $this->execLogObj->descr, 600, 1);
				}else{
					$add_params ['get_start'] = true;
					ControlFactory::add_label($defs, '', 'Запуск' . str_repeat(".", $this->counter));
				}
				ControlFactory::add_multiline_label($defs, '', $this->execLogObj->descr, 10);
				$action = UserInputHandlerRegistry::create_action($this, 'web_gui', $add_params);
				$attrs['timer'] = ActionFactory::timer(1000);
				$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($action));
				$caption = 'Запуск WEB GUI';
				$return = false;
			}else if (isset($user_input->get_started)){
				$this->counter = 0;
				$add_params ['get_stop'] = true;
				ControlFactory::add_close_dialog_and_apply_button(&$defs, $this, $add_params, 'web_gui', 'Остановить WEB GUI', 450);
				
				$txt='WEB GUI запущен. Откройте указанный ниже адрес в браузере на любом устройстве:';
				ControlFactory::add_multiline_label($defs, '', $txt, 10);
				ControlFactory::add_vgap($defs, -10);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">' .$ip_address.'</text>'
				);
				$qr_params['qr_str'] = $ip_address;
				ControlFactory::add_button(&$defs, $this, $qr_params, 'show_qr', '', 'QR code', 450);
				$txt='После настройки rclone остановите WEB GUI';
				ControlFactory::add_multiline_label($defs, '', $txt, 10);
				$return = false;
				$caption = "WEB GUI: $ip_address";
			}else if (isset($user_input->get_stop)){
				$pid = SmartConfig::rclone_rcd ();
				if ($pid == true)
					SmartConfig::do_cmd(DuneSystem::$properties['install_dir_path'] . "/bin/rclone_rcdstart.sh 'KILL'");			
				$action = null ;
#				$action = UserInputHandlerRegistry::create_action($this, '' ) ;
				$this->do_exec_log();
				if ($this->execLogObj->status === false)
					return ActionFactory::show_title_dialog('Error!', $action, $exec_log->descr, 600, 1);
				return $action;
			}else{
				$this->counter = 0;
				$caption = 'Запустить WEB GUI'.( ( file_exists('flashdata/plugins_data/rclone/autostart_remote_name') ) ? "  (cбросятся метки автозапуска)" : "" );
				$add_params ['get_start'] = true;
				ControlFactory::add_close_dialog_and_apply_button(&$defs, $this, $add_params, 'web_gui', $caption, 450);
				$txt='WEB GUI (веб интерфейс rclone) используется для добавления и удаления облачных сервисов. Для доступа к WEB GUI необходимо указать:';
				ControlFactory::add_multiline_label($defs, '', $txt, 3);
				ControlFactory::add_vgap($defs, -15);
				if ($user_pass != 'admin')
					$user_pass = preg_replace("|.|", "*", $user_pass);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">Логин: </text><text color="15" size="normal">'.$user_login.'</text>
					<text color="10" size="normal"> Пароль: </text><text color="15" size="normal">'.$user_pass.'</text>'
				);
				ControlFactory::add_vgap($defs, -15);
				ControlFactory::add_close_dialog_and_apply_button(&$defs, $this, null, 'login_settings', 'Изменить логин и пароль', 450);
				ControlFactory::add_vgap($defs, -15);
				ControlFactory::add_smart_label($defs, "", 
					'<text size="small">*При необходимости можно изменить логин и пароль для доступа к WEB GUI</text>'
				);
				ControlFactory::add_vgap($defs, -35);
				ControlFactory::add_smart_label($defs, "", 
					'<text size="small">**Логин отключить нельзя</text>'
				);
#				ControlFactory::add_close_dialog_button($defs, 'Закрыть', 450);
				$return = true;
				
			}
			return ActionFactory::show_dialog("WEB GUI", $defs, $return, 1250,$attrs);
		}
		if ($user_input->control_id == 'login_settings'){
			$defs = array();
			$login_settings = HD::get_items('login_settings');
			$user_login = isset($login_settings['user_login']) ? $login_settings['user_login'] : 'admin';
			$user_pass = isset($login_settings['user_pass']) ? $login_settings['user_pass'] : 'admin';
			if (isset($user_input->user_login)){
				$caption = '';
				if ($user_input->user_login == ''){
					if (isset($login_settings['user_login']))
						unset($login_settings['user_login']);
					$caption = "Логин задан по умолчанию\n";
				}else
					$login_settings['user_login'] = $user_input->user_login;
				if ($user_input->user_pass == ''){
					if (isset($login_settings['user_pass']))
						unset($login_settings['user_pass']);
					$caption .= 'Пароль задан по умолчанию';
				}else
					$login_settings['user_pass'] = $user_input->user_pass;
				HD::save_items('login_settings', $login_settings);
				$action = UserInputHandlerRegistry::create_action($this, 'web_gui');
				return ActionFactory::show_title_dialog('Логин и пароль сохранены', $action, $caption, 600, 1);
			}else{
				$ps = 1;
				if ($user_pass =='admin')
					$ps = 0;
				ControlFactory::add_text_field($defs, $this, null,
					'user_login',
					'',
					$user_login, 0, 0, 0, 1, 500, 0, false
				);
				ControlFactory::add_text_field($defs, $this, null,
					'user_pass',
					'',
					$user_pass, 0, $ps, 0, 1, 500, 0, false
				);
			}
			ControlFactory::add_close_dialog_and_apply_button($defs, $this, null, 'login_settings', 'Применить', 450);
			return ActionFactory::show_dialog("Логин в WEB GUI", $defs, true, 0, $attrs);
		}
		if ($user_input->control_id == 'show_qr'){
			$img = DuneSystem::$properties['tmp_dir_path'].'/img.jpeg';
			$doc = HD::http_get_document('https://api.qrserver.com/v1/create-qr-code/?size=450x450&format=jpeg&data='.$user_input->qr_str);
			file_put_contents ($img, $doc);
			ControlFactory::add_smart_label($defs,"", '<icon width="400" height="400">'.$img.'</icon>');
			ControlFactory::add_vgap($defs, 400);
			return  ActionFactory::show_dialog("QR code",$defs,true,500,$attrs);
		}		
		if ( $user_input->control_id == 'flag_Info_memory' || ( $this->flag_Info_memory && $this->title_counter > 40)){ 
			$this->flag_Info_memory = ! $this->flag_Info_memory ;
			$this->title_counter = 0;
			if ( $this->flag_Info_memory ){ 
				return ActionFactory::show_title_dialog("Внимание: включен Сервисный режим !", null , 
				"В нижнем 'баре' выводиться информация о свободной памяти для Андроид и Linux, датчики температуры, доступны дополнительные служебные функции, ряд функций работает иначе. ".
				"Для выхода из Сервисного режима нажмите <Select> или <A>, или он отключиться автоматически приблизительно после минуты вашего бездействия.", 1600, 0);
			}
		}
		if ($user_input->control_id == 'timer') {
			$this->main_actions = null ;
			return ActionFactory::change_behaviour($this->main_actions, 0, ActionFactory::invalidate_folders(array($user_input->parent_media_url)));
		}
		return UserInputHandlerRegistry::create_action($this, 'timer');			# 'загиб' в 'timer' на всякий случай
	}					

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies){
			$items = array();
			$config_array = array();
			if ( is_file(DuneSystem::$properties['data_dir_path'] .'/config') ) $config_array = parse_ini_file(DuneSystem::$properties['data_dir_path'] .'/config', true, INI_SCANNER_RAW);

			$this->title_counter++;
			$this->mount_counter = 0;
			$this->all_names_counter = '';

			SmartConfig::do_cmd('ps w | grep rclone > /flashdata/plugins_data/rclone/ps_tmp');
			$ps_out = file_get_contents ('/flashdata/plugins_data/rclone/ps_tmp');
			$rc_out = ( is_file('/flashdata/plugins_data/rclone/rc_port_cache_jobs') ? file_get_contents ('/flashdata/plugins_data/rclone/rc_port_cache_jobs') : '');
			$autostart_out = ( is_file('/flashdata/plugins_data/rclone/autostart_remote_name') ? file_get_contents ('/flashdata/plugins_data/rclone/autostart_remote_name') : '');

			foreach ($config_array as $k => $v){
			if ( ! $this->all_names_counter == '' ) {
				$this->all_names_counter .= ',';
			}
			$this->all_names_counter .= $k;

			$arr = array();  $starred = false;
			$color = 15; 
			$arr['caption'] =  $k;
			$arr['type'] =  $v['type'];
			$arr['team_drive'] =  $v['team_drive'];
			$description = '';
			$description .= '||Тип подключения:|'.  $v['type'];
#			$description .= '||Подключение:|' . $k .'||Тип подключения:|'.  $v['type'];
			if ( strpos( " ,".$autostart_out.", ",",".$k.",") ){
				$starred = true;
				$color = 14;
				$description .= '||Автозапуск';
				$arr['autostart'] =  1;
			}

#			$description .= '||Копирование по расписанию на:|'.  $k['type'];

			$priv_set='  ';
			if ( file_exists('flashdata/plugins_data/rclone/'.'settings_'.$k )){
				$priv_set='»';
				$color = 14;
				$description .= '||Индивидуальные настройки';
			}
			$asd = 'plugin_file://icons/cloud_off.png';
			$get_status_mount = $this->get_status_mount( $k, $ps_out, $rc_out ) ;
			if ( $get_status_mount >0 ){
				$this->mount_counter++;
				$color = 19;
				$description .= '||Состояние:|';
				$arr['launched'] =  1;
				if ( $get_status_mount == 1 ){
					$description .= 'Запущено';
					$asd = 'plugin_file://icons/'.$v['type'].'.png';
				}
				if ( $get_status_mount == 2 ){
					$description .= 'подготовка...';
					$arr['cached'] =  1;
					$asd = 'plugin_file://icons/wait.png';
				}
				if ( $get_status_mount == 3 ){
					$description .= 'кэшируется...';
					$arr['cached'] =  1;
					$asd = 'plugin_file://icons/timer.png';
				}
			}
			if ( strpos( $ps_out , "size ".$k.":")>0 ) {
				$arr['size_info'] =  1;
#				$color = 14;
				$description .= '||Идет подсчет размера...';
			}
			array_push
                (
                    $items,
                    array
                    (
                        PluginRegularFolderItem::caption => ''.$priv_set.$k,       # '»' предполагаемый маркер индивидуальных настроек
						PluginRegularFolderItem::starred => $starred,      # ЗВЕЗДОЧКА АВТОМОНТИРОВАНИЯ
                        PluginRegularFolderItem::view_item_params =>  array
					(
						ViewItemParams::icon_path => $asd,
                        ViewItemParams::item_layout => HALIGN_LEFT,
                        ViewItemParams::icon_valign => VALIGN_CENTER,
                        ViewItemParams::icon_dx => 10,
                        ViewItemParams::icon_dy => 0,
						ViewItemParams::icon_width => 55,
                        ViewItemParams::icon_height => 55,
                        ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
						ViewItemParams::item_detailed_info => $description,
						ViewItemParams::item_caption_color => $color,
#                        ViewItemParams::item_caption_width => ( ($this->View_num == 1) ? 1100 : 510) 
                        ViewItemParams::item_caption_width => ( ($this->View_num == 1) ? 1100 : 740)
                    ),
                        PluginRegularFolderItem::media_url => MediaURL::encode($arr)
                    )
                );
			}
			
			return $items;
    }

	private function get_install_folder_views(){

			if ( file_exists('/flashdata/plugins/rclone/icons/Number.txt') )	
				$this->View_num = file_get_contents('/flashdata/plugins/rclone/icons/Number.txt'); 

			return array(
                array (
                        PluginRegularFolderView::async_icon_loading => false,
                        PluginRegularFolderView::view_params => array
                            (
                            ViewParams::num_cols => $this->View_num,
                            ViewParams::num_rows => 10,
							ViewParams::paint_details => ($this->View_num == 1),
                            ViewParams::paint_item_info_in_details => true,
						ViewParams::background_path=> 'plugin_file://icons/bg_rclone.jpg',
						ViewParams::background_order => 0,
						ViewParams::background_height => 1080,
						ViewParams::background_width => 1920,
						ViewParams::optimize_full_screen_background => true,
							ViewParams::item_detailed_info_auto_line_break => false, # true !!! ??? разобраться зачем изменил
							ViewParams::item_detailed_info_title_color => 10,
							ViewParams::item_detailed_info_text_color => 15,
                        ),
                        PluginRegularFolderView::base_view_item_params =>
                        array
                            (
                            ViewItemParams::icon_path => 'missing://',
                            ViewItemParams::item_layout => HALIGN_LEFT,
                            ViewItemParams::icon_valign => VALIGN_CENTER,
                            ViewItemParams::icon_dx => 20,
                            ViewItemParams::icon_dy => -5,
                            ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
                            ViewItemParams::item_caption_width => 1550
                        ),
                        PluginRegularFolderView::not_loaded_view_item_params => array(),
						PluginRegularFolderView::timer => array(GuiTimerDef::delay_ms => 900 ),   # Обновление окна в микросекундах 
                    ), 
            );
    }

	private function move_up_or_down( $name , $flag_up, $qwe ){
 			$arr = explode('[', file_get_contents('/flashdata/plugins_data/rclone/config'));
			$nomer=0;
			for ($ii = 1; $ii < count($arr); $ii++) { 
				$arr[$ii]='['.$arr[$ii];
				if ( strpos( ' '.$arr[$ii].' ' , '['.$name.']') > 0 ){
					$nomer=$ii;
					$arr_nomer=$arr[$nomer];
				}
			}
			$doc='';
			if ( $flag_up ){
				if ( $nomer > 1 ){
					$arr[$nomer]=$arr[$nomer-1];	# выще
					$arr[$nomer-1]=$arr_nomer;
				}else{
					$doc='-';
				}
			}else{
				if ( $nomer  < (count($arr)-1) ){
					$arr[$nomer]=$arr[$nomer+1];	# ниже
					$arr[$nomer+1]=$arr_nomer;
				}else{
					$doc='-';
				}
			}
			if ( func_num_args()==3 ){
				return ( $doc=='' );
			}

			exec("rm /flashdata/plugins_data/rclone/config");
			file_put_contents('/flashdata/plugins_data/rclone/config', implode($arr));
   }


	public static function get_status_mount( $k, $ps_out=null, $rc_out=null ){
		if ( is_null($rc_out) ){
			$rc_out = ( is_file('/flashdata/plugins_data/rclone/rc_port_cache_jobs') ? file_get_contents ('/flashdata/plugins_data/rclone/rc_port_cache_jobs') : '');
		}
		if ( is_null($ps_out) ){
			$ps_out = file_get_contents ('/flashdata/plugins_data/rclone/ps_tmp');
		}
		$tmp_return =0 ;
		$start_poz = strpos( $ps_out , "mount ".$k.":");
		if ( $start_poz>0 ){
			$len_k = strlen($k);
#			$str_find =substr( $ps_out, $start_poz + $len_k + 23 , 14);		# сначала --rc потом --rc-addr
			$str_find =substr( $ps_out, $start_poz + $len_k + 23 - 5 , 14); # сначала --rc-addr потом --rc
			$tmp_return = 1 ;
			if ( strpos( ' '.$rc_out.' ' ,  $str_find) ){
				$tmp_return = 2;
			}
			if ( strpos( $ps_out , 'rclone rc vfs/refresh recursive=true --rc-addr '.$str_find) ){
				$tmp_return = 3 ;
			}
		}
		return $tmp_return ;
    }

	public static function get_open_mount( $k , $text='' ){
		$defs = array();
		SmartConfig::do_cmd('ps w | grep rclone > /flashdata/plugins_data/rclone/ps_tmp');
		$action = SmartConfig::remote_open( $k , $text ) ;
		if ( SmartListScreen::get_status_mount( $k ) > 1 ){	# Проверка на занятость кэшированием
			ControlFactory::add_multiline_label($defs, '', "Возможно медленное открытие и перемещение по каталогам");
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'', 'Все равно открыть', 600, $action );
			return ActionFactory::show_dialog("Подключение: ".$k.' - ещё кэшируется...', $defs, true ,1250);
		}
		return $action; 
	}


}

