<?php
class SmartConfig
{
	public static function get_data_path($reset=null) {
		static $link = null;
		if ($reset == true)
			$link = null;
		if (is_null($link))	{
			$link = DuneSystem::$properties['data_dir_path'];
			if (file_exists($link . '/data_dir_path'))
				$link = smbtree::get_folder_info ('data_dir_path');
		}
		return $link;
	}
	public static function get_autostart_remote_name() {
		$arn = '';
		$autostartPluginInRemote = (HD::get_item('autostartPluginInRemote') !='') ? HD::get_item('autostartPluginInRemote') : '';
		$autostart_remote_name = (HD::get_item('autostart_remote_name') !='') ? HD::get_item('autostart_remote_name') : '';
		if ($autostartPluginInRemote != ''){
			$arn['type'] = 2;
			$arn['remote_name'] = $autostartPluginInRemote;
		}
		if ($autostart_remote_name != ''){
			$arn['type'] = 1;
			$arn['remote_name'] = $autostart_remote_name;
		}
		return $arn;
	}
	public static function get_info_defs2 ($caption, $defs){
		if ((file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_remote_name'))&&
		($caption == trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_remote_name')))){
#			ControlFactory::add_smart_label($defs, "", 
#				'<text color="10" size="normal">Автозапуск: </text>
#				<text color="15" size="normal">Да</text>'
#			);
		}else{
#			ControlFactory::add_smart_label($defs, "", 
#				'<text color="10" size="normal">Автозапуск: </text>
#				<text color="15" size="normal">Нет</text>'
#			);
		}
		ControlFactory::add_vgap($defs, -20);
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Расположение кеша: </text>'
		);
		ControlFactory::add_vgap($defs, -20);
		$cache_dir = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_cache_dir_path') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_cache_dir_path')) : DuneSystem::$properties['data_dir_path'];
		ControlFactory::add_smart_label($defs, "", 
			'<text color="15" size="normal">'.$cache_dir.'</text>'
		);
		ControlFactory::add_vgap($defs, -20);
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Свободно: </text><text color="15" size="normal">'.HD::get_storage_size($cache_dir).'</text>'
		);
		$cache_max_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_cache_max_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_cache_max_size')) : "32M";
		ControlFactory::add_vgap($defs, -20);
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Максимальный размер кеша: </text>
			<text color="15" size="normal">'.$cache_max_size.'B</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$vfs_cache_mode = (HD::get_item('autostart_vfs_cache_mode') !='') ? HD::get_item('autostart_vfs_cache_mode') : "writes";
		if (!file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_write_mode'))
			$vfs_cache_mode = "readOnly";
		$vfs_cache_mode_ops["writes"] = "writes";
		$vfs_cache_mode_ops["full"] = "full";
		$vfs_cache_mode_ops["readOnly"] = "Только чтение";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Способ работы кеша: </text>
			<text color="15" size="normal">'.$vfs_cache_mode_ops[$vfs_cache_mode].'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$vfs_read_chunk_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_read_chunk_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_read_chunk_size')) : "32M";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Размер частей чтения файлов: </text>
			<text color="15" size="normal">'.$vfs_read_chunk_size.'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$buffer_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_buffer_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_buffer_size')) : "16M";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Размер буфера: </text>
			<text color="15" size="normal">'.$buffer_size.'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$vfs_read_chunk_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/vfs_cache_poll_interval') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/vfs_cache_poll_interval')) : "60";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">vfs-cache-poll-interval, сек.: </text>
			<text color="15" size="normal">'.$vfs_read_chunk_size.'</text>'
		);
		return $defs;
	}
	public static function get_info_defs ($defs){
		ControlFactory::add_vgap($defs, -25);
		$cache_dir_path = DuneSystem::$properties['data_dir_path'];
		if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_cache_dir_path'))
			$cache_dir_path = file_get_contents(DuneSystem::$properties['data_dir_path'] . '/autostart_cache_dir_path');
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Расположение кеша: </text>'
		);
		ControlFactory::add_vgap($defs, -25);
		ControlFactory::add_smart_label($defs, "", 
			'<text color="15" size="normal">'.$cache_dir_path.'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Свободно: </text><text color="15" size="normal">'.HD::get_storage_size($cache_dir_path).'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$cache_dir_path = '32M';
		if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_cache_max_size'))
			$cache_dir_path = file_get_contents(DuneSystem::$properties['data_dir_path'] . '/autostart_cache_max_size');
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Максимальный размер кеша: </text>
			<text color="15" size="normal">'.$cache_dir_path.'B</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$vfs_cache_mode = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_cache_mode') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_cache_mode')) : "writes";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Способ работы кеша: </text>
			<text color="15" size="normal">'.$vfs_cache_mode.'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$vfs_read_chunk_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_read_chunk_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_read_chunk_size')) : "32M";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Размер частей чтения файлов: </text>
			<text color="15" size="normal">'.$vfs_read_chunk_size.'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$buffer_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_buffer_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_buffer_size')) : "16M";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">Размер буфера: </text>
			<text color="15" size="normal">'.$buffer_size.'</text>'
		);
		ControlFactory::add_vgap($defs, -25);
		$vfs_read_chunk_size = file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_read_chunk_size') ? trim(file_get_contents (DuneSystem::$properties['data_dir_path'] .'/autostart_vfs_read_chunk_size')) : "60";
		ControlFactory::add_smart_label($defs, "", 
			'<text color="10" size="normal">vfs-cache-poll-interval, сек.: </text>
			<text color="15" size="normal">'.$vfs_read_chunk_size.'</text>'
		);
		return $defs;
	}
	public static function get_remote_info_defs ($defs){
		$rclone_mount = SmartConfig::rclone_mount();
		if ($rclone_mount == true){
			$config_array = parse_ini_file(DuneSystem::$properties['data_dir_path'] .'/config', true, INI_SCANNER_RAW);
			if (preg_match('|mount\s+(.+?):\s+(.+?)--|', $rclone_mount, $matches)){
				$type = 'n/a';
				if (isset($config_array[trim($matches[1])]['type']))
					$type = $config_array[trim($matches[1])]['type'];
				$remote_name = trim($matches[1]);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">Имя подключения: </text>
					<text color="15" size="normal">'.$remote_name.'</text>'
				);
				ControlFactory::add_vgap($defs, -25);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">Тип подключения: </text>
					<text color="15" size="normal">'.$type.'</text>'
				);
				ControlFactory::add_vgap($defs, -25);
				$autostart_remote_name = SmartConfig::get_autostart_remote_name();
				if (isset($autostart_remote_name['remote_name'])){
					$remote_name = $autostart_remote_name['remote_name'];
					$autostart_type = $autostart_remote_name['type'];
					ControlFactory::add_smart_label($defs, "", 
						'<text color="10" size="normal">Автозапуск: </text>
						<text color="15" size="normal">Да</text>'
					);
					ControlFactory::add_vgap($defs, -25);
					$autostart_type_ops[1]=' при включении плеера';
					$autostart_type_ops[2]=' при входе в плагин';
					ControlFactory::add_smart_label($defs, "", 
						'<text color="10" size="normal">Тип автозапуска: </text>
						<text color="15" size="normal">'.$autostart_type_ops[$autostart_type].'</text>'
					);
				}else{
					ControlFactory::add_smart_label($defs, "", 
						'<text color="10" size="normal">Автозапуск: </text>
						<text color="15" size="normal">Нет</text>'
					);
				}
				ControlFactory::add_vgap($defs, -25);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="10" size="normal">Смонтированно: </text>'
				);
				ControlFactory::add_vgap($defs, -25);
				ControlFactory::add_smart_label($defs, "", 
					'<text color="15" size="normal">'.trim($matches[2]).'</text>'
				);
				ControlFactory::add_vgap($defs, -25);
				$rclone_mount = preg_replace("|\s+|", " ", $rclone_mount);
				$tmp = explode(' ', $rclone_mount);
				foreach ($tmp as $k => $v){
					if (preg_match('|cache-dir|', $v)){
						ControlFactory::add_smart_label($defs, "", 
							'<text color="10" size="normal">Расположение кеша: </text>'
						);
						ControlFactory::add_vgap($defs, -25);
						ControlFactory::add_smart_label($defs, "", 
							'<text color="15" size="normal">'.$tmp[$k + 1].'</text>'
						);
						ControlFactory::add_vgap($defs, -25);
						ControlFactory::add_smart_label($defs, "", 
							'<text color="10" size="normal">Свободно: </text><text color="15" size="normal">'.HD::get_storage_size($tmp[$k + 1]).'</text>'
						);
						ControlFactory::add_vgap($defs, -25);
					}
					if (preg_match('|cache-max-size|', $v)){
						ControlFactory::add_smart_label($defs, "", 
							'<text color="10" size="normal">Максимальный размер кеша: </text>
							<text color="15" size="normal">'.$tmp[$k + 1].'B</text>'
						);
						ControlFactory::add_vgap($defs, -25);
					}
					if (preg_match('|vfs-cache-mode|', $v)){
						if (preg_match('|--read-only|', $rclone_mount))
							ControlFactory::add_smart_label($defs, "", 
								'<text color="10" size="normal">Способ работы кеша: </text>
								<text color="15" size="normal">read-only</text>'
							);
						else
							ControlFactory::add_smart_label($defs, "", 
								'<text color="10" size="normal">Способ работы кеша: </text>
								<text color="15" size="normal">'.$tmp[$k + 1].'</text>'
							);
						ControlFactory::add_vgap($defs, -25);
					}
					if (preg_match('|vfs-read-chunk-size$|', $v)){
						ControlFactory::add_smart_label($defs, "", 
							'<text color="10" size="normal">Размер частей чтения файлов: </text>
							<text color="15" size="normal">'.$tmp[$k + 1].'</text>'
						);
						ControlFactory::add_vgap($defs, -25);
					}
					if (preg_match('|buffer-size|', $v)){
						ControlFactory::add_smart_label($defs, "", 
							'<text color="10" size="normal">Размер буфера: </text>
							<text color="15" size="normal">'.$tmp[$k + 1].'</text>'
						);
					}
				}
			}
		}else
			ControlFactory::add_smart_label($defs, "", 
				'<text color="10" size="normal">Запущенное подключение: </text>
				<text color="21" size="normal">не найдено</text>'
			);
		return $defs;
	}
	public static function remote_open ($mount_path, $title_mount_path){
		$prefix = 'tmpfs';
		if (HD::get_platform_kind() == 'android')
			$prefix = "internal_memory";
		$url = "embedded_app://{name=file_browser}{url=$prefix://$mount_path}{caption=$title_mount_path$mount_path}";
		hd_print("open_file_browser, url: '$url'");
		return ActionFactory::launch_media_url($url);
	}
	public static function fuse_mount_dir_path (){
		if (HD::get_platform_kind() == 'android')
			return "/sdcard/DuneHD/";
		else
			return "/tmp/tmpfs/";
	}
	public static function save_autostart_remote($autostart_remote, $type=null){//2
		if (($type==true)&&($type==2)){
			if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_remote_name'))
				unlink (DuneSystem::$properties['data_dir_path'] . '/autostart_remote_name');
			HD::save_item('autostartPluginInRemote', $autostart_remote);
		}else{
			if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostartPluginInRemote'))
				unlink (DuneSystem::$properties['data_dir_path'] . '/autostartPluginInRemote');
			HD::save_item('autostart_remote_name', $autostart_remote);
		}
		HD::save_item('autostart_fuse_mount_dir_path', SmartConfig::fuse_mount_dir_path () . trim($autostart_remote));
	}
	public static function save_cache_dir_path ($cache_dir){//1
		$oldCache_dir = (HD::get_item('autostart_cache_dir_path') !='') ? HD::get_item('autostart_cache_dir_path') : DuneSystem::$properties['data_dir_path'];
		if (trim($cache_dir) != DuneSystem::$properties['data_dir_path'])
			$cache_dir = trim($cache_dir) .'/'. DuneSystem::$properties['plugin_name'];
		if (trim($oldCache_dir) != $cache_dir){
			HD::save_item('autostart_cache_dir_path', $cache_dir);
			if ($oldCache_dir == DuneSystem::$properties['data_dir_path'])
				$oldCache_dir = DuneSystem::$properties['data_dir_path'] . '/vfs';
			system("rm -rf $oldCache_dir");
		}
		return $cache_dir;
	}
	public static function save_cache_max_size ($cache_max_size){
		if (($cache_max_size == '32M')
			||($cache_max_size == 'G')
			||($cache_max_size == 'M')
			||($cache_max_size == '0G')
			||($cache_max_size == '0M')
		)
		{
			$cache_max_size = '32M';
		if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostart_cache_max_size'))
			unlink (DuneSystem::$properties['data_dir_path'] . '/autostart_cache_max_size');
		}else
			file_put_contents(DuneSystem::$properties['data_dir_path'] . '/autostart_cache_max_size', trim($cache_max_size));
		return $cache_max_size;
	}
	public static function autostart_remove (){
		if (file_exists(DuneSystem::$properties['data_dir_path'] . '/autostartPluginInRemote'))
			unlink (DuneSystem::$properties['data_dir_path'] . '/autostartPluginInRemote');
		if (file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_remote_name'))
			unlink (DuneSystem::$properties['data_dir_path'] . '/autostart_remote_name');
		if (file_exists(DuneSystem::$properties['data_dir_path'] .'/autostart_fuse_mount_dir_path'))
			unlink (DuneSystem::$properties['data_dir_path'] . '/autostart_fuse_mount_dir_path');
	}
	public static function rclone_rcd (){
		if (HD::get_platform_kind() == '87xx')
			$rclone_rcd = exec('ps aux | grep "[r]clone rcd" | awk \'{print $2}\'');
		else if (HD::get_platform_kind() == 'android'){
			$rclone_rcd = exec('/system/dunehd/dunehd_service do "ps w | grep \"[r]clone rcd\" | awk \'{print $1}\'"');
			if (preg_match('|(\d+?)\s|', $rclone_rcd, $match))
				$rclone_rcd = $match[1];
		}else
			$rclone_rcd = exec("ps | grep \"[r]clone rcd\" | awk '{print $1}'");
		echo "rclone_rcd-->$rclone_rcd<--";
		return $rclone_rcd;
	}
	public static function rclone_mount (){
		if (HD::get_platform_kind() == '87xx')
			$rclone_mount = exec('ps aux | grep "[r]clone mount"');
		else if (HD::get_platform_kind() == 'android')
			$rclone_mount = exec('/system/dunehd/dunehd_service do "ps w | grep \"[r]clone mount\""');
		else
			$rclone_mount = exec('ps w | grep "[r]clone mount"');
		echo "rclone_mount-->$rclone_mount<--";
		return $rclone_mount;
	}
	public static function do_cmd($do_cmd){
#		echo "cmd-->" . $do_cmd;
		$exec_log = DuneSystem::$properties['tmp_dir_path'].'/exec_log';
		if (file_exists($exec_log))
			system("rm -rf $exec_log");
		if (HD::get_platform_kind() == 'android')
			system('/system/dunehd/dunehd_service do "' . str_replace('"','\"', $do_cmd) . '"');
		else
			system($do_cmd);
    }
}
?>
